using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.MakeAppointmentRequestMessage)]
	[DataContract]
	public class MakeAppointmentRequestMessage : MessageBase
	{
		[DataMember]
		public string OrganizationName { get; set; }
		[DataMember]
		public Guid UserId { get; set; }
		[DataMember]
		public Guid RelatedParentId { get; set; }
		[DataMember]
		public string RelatedParentEntityName { get; set; }
		[DataMember]
		public string RelatedParentFieldName { get; set; }
		[DataMember]
		public bool LogTiming { get; set; }
		[DataMember]
		public bool LogSoap { get; set; }
		[DataMember]
		public bool Debug { get; set; }
        [DataMember]
        public bool LogRequest { get; set; }
        [DataMember]
        public Guid AppointmentId { get; set; }
        [DataMember]
        public List<Guid> AddedPatients { get; set; }
        [DataMember]
		public MakeApptReqQueryBean MakeApptReqQueryBeanInfo { get; set; }
		[DataMember]
		public MakeApptReqAppointment MakeApptReqAppointmentInfo { get; set; }
	}

	[DataContract]
	public class MakeApptReqQueryBean
	{
		[DataMember]
		public string RecordSiteCode { get; set; }
		[DataMember]
		public string RequestingApp { get; set; }
		[DataMember]
		public string Active { get; set; }
		[DataMember]
		public string EndDate { get; set; }
		[DataMember]
		public string StartDate { get; set; }
		[DataMember]
		public string MaxRecords { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string SupplementalParameters { get; set; }
		[DataMember]
		public string ItemId { get; set; }
		[DataMember]
		public string Target { get; set; }
		[DataMember]
		public string Criteria { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string Direction { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public bool MultiSiteQuery { get; set; }
		[DataMember]
		public string ConsumingAppToken { get; set; }
		[DataMember]
		public string ConsumingAppPassword { get; set; }
		[DataMember]
		public MakeApptReqProvider MakeApptReqProviderInfo { get; set; }
		[DataMember]
		public MakeApptReqPatient MakeApptReqPatientInfo { get; set; }
	}

	[DataContract]
	public class MakeApptReqProvider
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string UserId { get; set; }
		[DataMember]
		public string LoginSiteCode { get; set; }
		[DataMember]
		public string ContextMenu { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
	}

	[DataContract]
	public class MakeApptReqPatient
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string LocalPid { get; set; }
		[DataMember]
		public string LocalSiteId { get; set; }
		[DataMember]
		public string MpiPid { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
		[DataMember]
		public string Ss { get; set; }
		[DataMember]
		public string InPatient { get; set; }
		[DataMember]
		public string Age { get; set; }
		[DataMember]
		public string Gender { get; set; }
		[DataMember]
		public string ScPercentage { get; set; }
	}

	[DataContract]
	public class MakeApptReqAppointment
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Timestamp { get; set; }
		[DataMember]
		public string Title { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string LabDateTime { get; set; }
		[DataMember]
		public string XrayDateTime { get; set; }
		[DataMember]
		public string EkgDateTime { get; set; }
		[DataMember]
		public string Purpose { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string CurrentStatus { get; set; }
		[DataMember]
		public string ClinicId { get; set; }
		[DataMember]
		public string AppointmentTimestamp { get; set; }
		[DataMember]
		public string PurposeSubcategory { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string AppointmentType { get; set; }
		[DataMember]
		public string BookNotes { get; set; }
		[DataMember]
		public string ConsultIen { get; set; }
		[DataMember]
		public string Lvl { get; set; }
		[DataMember]
		public string DesiredDateTime { get; set; }
		[DataMember]
		public string VisitId { get; set; }
		[DataMember]
		public string ProviderName { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string CancelCode { get; set; }
		[DataMember]
		public string CancelReason { get; set; }
		[DataMember]
		public string Remarks { get; set; }
		[DataMember]
		public MakeApptRespFacility MakeApptRespFacilityInfo { get; set; }
		[DataMember]
		public MakeApptReqClinic MakeApptReqClinicInfo { get; set; }
	}

	[DataContract]
	public class MakeApptReqFacility
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string LastEvent { get; set; }
		[DataMember]
		public string LastSeenDate { get; set; }
		[DataMember]
		public string Name { get; set; }
	}

	[DataContract]
	public class MakeApptReqClinic
	{
		[DataMember]
		public string Abbr { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string AppointmentTimestamp { get; set; }
		[DataMember]
		public bool AskForCheckIn { get; set; }
		[DataMember]
		public bool AskForCheckInSpecified { get; set; }
		[DataMember]
		public string Bed { get; set; }
		[DataMember]
		public string Building { get; set; }
		[DataMember]
		public string DisplayIncrements { get; set; }
		[DataMember]
		public string DispositionAction { get; set; }
		[DataMember]
		public string Floor { get; set; }
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string MaxOverbooksPerDay { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string PhysicalLocation { get; set; }
		[DataMember]
		public string ProhibitAccessToClinic { get; set; }
		[DataMember]
		public string Room { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string VisitLocation { get; set; }
		[DataMember]
		public string SiteId { get; set; }
		[DataMember]
		public MakeApptReqAvailabilityMultipleResponse[] MakeApptReqAvailabilityInfo { get; set; }
		[DataMember]
		public MakeApptReqCreditStopCode MakeApptReqCreditStopCodeInfo { get; set; }
		[DataMember]
		public MakeApptReqDepartment MakeApptReqDepartmentInfo { get; set; }
		[DataMember]
		public MakeApptReqDivision MakeApptReqDivisionInfo { get; set; }
		[DataMember]
		public MakeApptReqFacility1 MakeApptReqFacility1Info { get; set; }
		[DataMember]
		public MakeApptReqInstitution MakeApptReqInstitutionInfo { get; set; }
		[DataMember]
		public MakeApptReqModule MakeApptReqModuleInfo { get; set; }
		[DataMember]
		public MakeApptReqPrincipalClinic MakeApptReqPrincipalClinicInfo { get; set; }
		[DataMember]
		public MakeApptReqService MakeApptReqServiceInfo { get; set; }
		[DataMember]
		public MakeApptReqSpecialty MakeApptReqSpecialtyInfo { get; set; }
		[DataMember]
		public MakeApptReqStopCode MakeApptReqStopCodeInfo { get; set; }
		[DataMember]
		public MakeApptReqTypeExtension MakeApptReqTypeExtensionInfo { get; set; }
		[DataMember]
		public MakeApptReqWardLocation MakeApptReqWardLocationInfo { get; set; }
		[DataMember]
		public MakeApptReqFault MakeApptReqFaultInfo { get; set; }
	}

	[DataContract]
	public class MakeApptReqAvailabilityMultipleResponse
	{
		[DataMember]
		public bool Available { get; set; }
		[DataMember]
		public string End { get; set; }
		[DataMember]
		public string Start { get; set; }
		[DataMember]
		public string Text { get; set; }
	}

	[DataContract]
	public class MakeApptReqCreditStopCode
	{
		[DataMember]
		public object Key { get; set; }
		[DataMember]
		public object Value { get; set; }
	}

	[DataContract]
	public class MakeApptReqDepartment
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqDivision
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqFacility1
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string LastEvent { get; set; }
		[DataMember]
		public string LastSeenDate { get; set; }
		[DataMember]
		public string Name { get; set; }
	}

	[DataContract]
	public class MakeApptReqInstitution
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqModule
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqPrincipalClinic
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqService
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqSpecialty
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqStopCode
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqTypeExtension
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqWardLocation
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class MakeApptReqFault
	{
		[DataMember]
		public string InnerMessage { get; set; }
		[DataMember]
		public string InnerStackTrace { get; set; }
		[DataMember]
		public string InnerType { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string StackTrace { get; set; }
		[DataMember]
		public string Suggestion { get; set; }
		[DataMember]
		public string Type { get; set; }
	}
}