using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.LoginViaResponseMessage)]
	[DataContract]
	public class LoginViaResponseMessage : MessageBase
	{
		[DataMember]
		public LoginViaRespUserTo LoginViaRespUserToInfo { get; set; }
		[DataMember]
		public bool ExceptionOccured { get; set; }
		[DataMember]
	    public string ExceptionMessage { get; set; }
        [DataMember]
        public string SerializedInstance { get; set; }
        [DataMember]
        public string VimtRequest { get; set; }
        [DataMember]
        public string VimtResponse { get; set; }
        [DataMember]
        public string ViaUserId { get; set; }
    }

	[DataContract]
	public class LoginViaRespUserTo
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Ss { get; set; }
		[DataMember]
		public string Duz { get; set; }
		[DataMember]
		public string SiteId { get; set; }
		[DataMember]
		public string Office { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string Pager { get; set; }
		[DataMember]
		public string Service { get; set; }
		[DataMember]
		public string Title { get; set; }
		[DataMember]
		public string OrderRole { get; set; }
		[DataMember]
		public string UserClass { get; set; }
		[DataMember]
		public string Greeting { get; set; }
		[DataMember]
		public string SiteMessage { get; set; }
		[DataMember]
		public string EmailAddress { get; set; }
		[DataMember]
		public string Username { get; set; }
		[DataMember]
		public string VistaDuz { get; set; }
		[DataMember]
		public LoginViaRespIds LoginViaRespIdsInfo { get; set; }
		[DataMember]
		public LoginViaRespDivisionsMultipleResponse[] LoginViaRespDivisionsInfo { get; set; }
		[DataMember]
		public LoginViaRespFault2 LoginViaRespFault2Info { get; set; }
	}

	[DataContract]
	public class LoginViaRespIds
	{
		[DataMember]
		public bool TextOnly { get; set; }
		[DataMember]
		public bool TextOnlySpecified { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public LoginViaRespResultsMultipleResponse[] LoginViaRespResultsInfo { get; set; }
		[DataMember]
		public LoginViaRespFault1 LoginViaRespFault1Info { get; set; }
	}

	[DataContract]
	public class LoginViaRespResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public LoginViaRespTaggedResultsMultipleResponse[] LoginViaRespTaggedResultsInfo { get; set; }
		[DataMember]
		public LoginViaRespFault LoginViaRespFaultInfo { get; set; }
	}

	[DataContract]
	public class LoginViaRespTaggedResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class LoginViaRespFault
	{
		[DataMember]
		public string InnerMessage { get; set; }
		[DataMember]
		public string InnerStackTrace { get; set; }
		[DataMember]
		public string InnerType { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string StackTrace { get; set; }
		[DataMember]
		public string Suggestion { get; set; }
		[DataMember]
		public string Type { get; set; }
	}

	[DataContract]
	public class LoginViaRespFault1
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class LoginViaRespDivisionsMultipleResponse
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string SiteId { get; set; }
	}

	[DataContract]
	public class LoginViaRespFault2
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }
}