using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
	[Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.LoginViaRequestMessage)]
	[DataContract]
	public class LoginViaRequestMessage : MessageBase
	{
		[DataMember]
		public string OrganizationName { get; set; }
		[DataMember]
		public Guid UserId { get; set; }
		[DataMember]
		public Guid RelatedParentId { get; set; }
		[DataMember]
		public string RelatedParentEntityName { get; set; }
		[DataMember]
		public string RelatedParentFieldName { get; set; }
		[DataMember]
		public bool LogTiming { get; set; }
		[DataMember]
		public bool LogSoap { get; set; }
		[DataMember]
		public bool Debug { get; set; }
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Accesscode { get; set; }
		[DataMember]
		public string Verifycode { get; set; }
        [DataMember]
        public bool LogRequest { get; set; }
        [DataMember]
        public string StationNumber { get; set; }
        [DataMember]
        public string FakeResponseType { get; set; }
        [DataMember]
		public LoginViaReqQueryBean LoginViaReqQueryBeanInfo { get; set; }
	}

	[DataContract]
	public class LoginViaReqQueryBean
	{
		[DataMember]
		public string RecordSiteCode { get; set; }
		[DataMember]
		public string RequestingApp { get; set; }
		[DataMember]
		public string Active { get; set; }
		[DataMember]
		public string EndDate { get; set; }
		[DataMember]
		public string StartDate { get; set; }
		[DataMember]
		public string MaxRecords { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string SupplementalParameters { get; set; }
		[DataMember]
		public string ItemId { get; set; }
		[DataMember]
		public string Target { get; set; }
		[DataMember]
		public string Criteria { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string Direction { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public bool MultiSiteQuery { get; set; }
		[DataMember]
		public string ConsumingAppToken { get; set; }
		[DataMember]
		public string ConsumingAppPassword { get; set; }
		[DataMember]
		public LoginViaReqProvider LoginViaReqProviderInfo { get; set; }
		[DataMember]
		public LoginViaReqPatient LoginViaReqPatientInfo { get; set; }
	}

	[DataContract]
	public class LoginViaReqProvider
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string UserId { get; set; }
		[DataMember]
		public string LoginSiteCode { get; set; }
		[DataMember]
		public string ContextMenu { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
	}

	[DataContract]
	public class LoginViaReqPatient
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string LocalPid { get; set; }
		[DataMember]
		public string LocalSiteId { get; set; }
		[DataMember]
		public string MpiPid { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
		[DataMember]
		public string Ss { get; set; }
		[DataMember]
		public string InPatient { get; set; }
		[DataMember]
		public string Age { get; set; }
		[DataMember]
		public string Gender { get; set; }
		[DataMember]
		public string ScPercentage { get; set; }
	}
}