using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.GetConsultsForPatientResponse)]
	[DataContract]
	public class GetConsultsForPatientResponse : MessageBase
	{
		[DataMember]
		public GetConsultsForPatientRespTaggedConsultArrays PatGetConsultsForPatientRespTaggedConsultArraysInfo { get; set; }
        [DataMember]
        public GetConsultsForPatientRespTaggedConsultArrays ProGetConsultsForPatientRespTaggedConsultArraysInfo { get; set; }
        [DataMember]
		public bool ExceptionOccured { get; set; }
		[DataMember]
		public string ExceptionMessage { get; set; }
        [DataMember]
        public string VimtResponse { get; set; }
        [DataMember]
        public string VimtRequest { get; set; }
        [DataMember]
        public string SerializedInstance { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespTaggedConsultArrays
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetConsultsForPatientRespArraysMultipleResponse[] GetConsultsForPatientRespArraysInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault24 GetConsultsForPatientRespFault24Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespArraysMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetConsultsForPatientRespConsultsMultipleResponse[] GetConsultsForPatientRespConsultsInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault23 GetConsultsForPatientRespFault23Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespConsultsMultipleResponse
	{
		[DataMember]
		public string Title { get; set; }
		[DataMember]
		public string RequestedProcedure { get; set; }
		[DataMember]
		public string ConsultIen { get; set; }
		[DataMember]
		public string RequestDate { get; set; }
		[DataMember]
		public string ServiceIen { get; set; }
		[DataMember]
		public string ServiceName { get; set; }
		[DataMember]
		public string PatientDfn { get; set; }
		[DataMember]
		public string PatientName { get; set; }
		[DataMember]
		public string SendingProviderDuz { get; set; }
		[DataMember]
		public string SendingProviderName { get; set; }
		[DataMember]
		public string ProvisionalDiagnosis { get; set; }
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Timestamp { get; set; }
		[DataMember]
		public string OrderingServiceName { get; set; }
		[DataMember]
		public string TreatingSpecialty { get; set; }
		[DataMember]
		public string StartDate { get; set; }
		[DataMember]
		public string StopDate { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string DateSigned { get; set; }
		[DataMember]
		public string VerifyingNurse { get; set; }
		[DataMember]
		public string DateVerified { get; set; }
		[DataMember]
		public string VerifyingClerk { get; set; }
		[DataMember]
		public string ChartReviewer { get; set; }
		[DataMember]
		public string DateReviewed { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string Detail { get; set; }
		[DataMember]
		public string ErrMsg { get; set; }
		[DataMember]
		public bool Flag { get; set; }
		[DataMember]
		public bool FlagSpecified { get; set; }
		[DataMember]
		public GetConsultsForPatientRespToService GetConsultsForPatientRespToServiceInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespSigStatus GetConsultsForPatientRespSigStatusInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespProvider GetConsultsForPatientRespProviderInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespType GetConsultsForPatientRespTypeInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespLocation GetConsultsForPatientRespLocationInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault22 GetConsultsForPatientRespFault22Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespToService
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResultsMultipleResponse[] GetConsultsForPatientRespTaggedResultsInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault GetConsultsForPatientRespFaultInfo { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault
	{
		[DataMember]
		public string InnerMessage { get; set; }
		[DataMember]
		public string InnerStackTrace { get; set; }
		[DataMember]
		public string InnerType { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string StackTrace { get; set; }
		[DataMember]
		public string Suggestion { get; set; }
		[DataMember]
		public string Type { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespSigStatus
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Value { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault1 GetConsultsForPatientRespFault1Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault1
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespProvider
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Ss { get; set; }
		[DataMember]
		public string Duz { get; set; }
		[DataMember]
		public string SiteId { get; set; }
		[DataMember]
		public string Office { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string Pager { get; set; }
		[DataMember]
		public string Service { get; set; }
		[DataMember]
		public string Title { get; set; }
		[DataMember]
		public string OrderRole { get; set; }
		[DataMember]
		public string UserClass { get; set; }
		[DataMember]
		public string Greeting { get; set; }
		[DataMember]
		public string SiteMessage { get; set; }
		[DataMember]
		public string EmailAddress { get; set; }
		[DataMember]
		public string Username { get; set; }
		[DataMember]
		public string VistaDuz { get; set; }
		[DataMember]
		public GetConsultsForPatientRespIds GetConsultsForPatientRespIdsInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespDivisionsMultipleResponse[] GetConsultsForPatientRespDivisionsInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault4 GetConsultsForPatientRespFault4Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespIds
	{
		[DataMember]
		public bool TextOnly { get; set; }
		[DataMember]
		public bool TextOnlySpecified { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetConsultsForPatientRespResultsMultipleResponse[] GetConsultsForPatientRespResultsInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault3 GetConsultsForPatientRespFault3Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResults1MultipleResponse[] GetConsultsForPatientRespTaggedResults1Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault2 GetConsultsForPatientRespFault2Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResults1MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault2
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault3
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespDivisionsMultipleResponse
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string SiteId { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault4
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespType
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Name1 { get; set; }
		[DataMember]
		public string Name2 { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault5 GetConsultsForPatientRespFault5Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault5
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespLocation
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Building { get; set; }
		[DataMember]
		public string Floor { get; set; }
		[DataMember]
		public string Room { get; set; }
		[DataMember]
		public string Bed { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string AppointmentTimestamp { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string PhysicalLocation { get; set; }
		[DataMember]
		public bool AskForCheckIn { get; set; }
		[DataMember]
		public bool AskForCheckInSpecified { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string ClinicDisplayStartTime { get; set; }
		[DataMember]
		public string DisplayIncrements { get; set; }
		[DataMember]
		public string MaxOverbooksPerDay { get; set; }
		[DataMember]
		public string ProhibitAccessToClinic { get; set; }
		[DataMember]
		public GetConsultsForPatientRespDepartment GetConsultsForPatientRespDepartmentInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespService GetConsultsForPatientRespServiceInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespSpecialty GetConsultsForPatientRespSpecialtyInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespStopCode GetConsultsForPatientRespStopCodeInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespCreditStopCode GetConsultsForPatientRespCreditStopCodeInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFacility GetConsultsForPatientRespFacilityInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespAvailability GetConsultsForPatientRespAvailabilityInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault21 GetConsultsForPatientRespFault21Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespDepartment
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResults2MultipleResponse[] GetConsultsForPatientRespTaggedResults2Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault6 GetConsultsForPatientRespFault6Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResults2MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault6
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespService
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResults3MultipleResponse[] GetConsultsForPatientRespTaggedResults3Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault7 GetConsultsForPatientRespFault7Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResults3MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault7
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespSpecialty
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResults4MultipleResponse[] GetConsultsForPatientRespTaggedResults4Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault8 GetConsultsForPatientRespFault8Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResults4MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault8
	{
		[DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespStopCode
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResults5MultipleResponse[] GetConsultsForPatientRespTaggedResults5Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault9 GetConsultsForPatientRespFault9Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResults5MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault9
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespCreditStopCode
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResults6MultipleResponse[] GetConsultsForPatientRespTaggedResults6Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault10 GetConsultsForPatientRespFault10Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResults6MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault10
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFacility
	{
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string DisplayName { get; set; }
		[DataMember]
		public string Moniker { get; set; }
		[DataMember]
		public string RegionId { get; set; }
		[DataMember]
		public string LastEventTimestamp { get; set; }
		[DataMember]
		public string LastEventReason { get; set; }
		[DataMember]
		public string Uid { get; set; }
		[DataMember]
		public string Pid { get; set; }
		[DataMember]
		public string ParentSiteId { get; set; }
		[DataMember]
		public string Address { get; set; }
		[DataMember]
		public string City { get; set; }
		[DataMember]
		public string State { get; set; }
		[DataMember]
		public string SystemName { get; set; }
		[DataMember]
		public string SiteType { get; set; }
		[DataMember]
		public GetConsultsForPatientRespDataSources GetConsultsForPatientRespDataSourcesInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespChildSites GetConsultsForPatientRespChildSitesInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault18 GetConsultsForPatientRespFault18Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespDataSources
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetConsultsForPatientRespItemsMultipleResponse[] GetConsultsForPatientRespItemsInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault13 GetConsultsForPatientRespFault13Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespItemsMultipleResponse
	{
		[DataMember]
		public string Protocol { get; set; }
		[DataMember]
		public string Modality { get; set; }
		[DataMember]
		public int Timeout { get; set; }
		[DataMember]
		public int Port { get; set; }
		[DataMember]
		public string Provider { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Description { get; set; }
		[DataMember]
		public string Context { get; set; }
		[DataMember]
		public bool TestSource { get; set; }
		[DataMember]
		public string Vendor { get; set; }
		[DataMember]
		public string Version { get; set; }
		[DataMember]
		public string WelcomeMessage { get; set; }
		[DataMember]
		public GetConsultsForPatientRespSiteId GetConsultsForPatientRespSiteIdInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault12 GetConsultsForPatientRespFault12Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespSiteId
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResults7MultipleResponse[] GetConsultsForPatientRespTaggedResults7Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault11 GetConsultsForPatientRespFault11Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResults7MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault11
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault12
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault13
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespChildSites
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetConsultsForPatientRespSitesMultipleResponse[] GetConsultsForPatientRespSitesInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault17 GetConsultsForPatientRespFault17Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespSitesMultipleResponse
	{
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string DisplayName { get; set; }
		[DataMember]
		public string Moniker { get; set; }
		[DataMember]
		public string RegionId { get; set; }
		[DataMember]
		public string LastEventTimestamp { get; set; }
		[DataMember]
		public string LastEventReason { get; set; }
		[DataMember]
		public string Uid { get; set; }
		[DataMember]
		public string Pid { get; set; }
		[DataMember]
		public string ParentSiteId { get; set; }
		[DataMember]
		public string Address { get; set; }
		[DataMember]
		public string City { get; set; }
		[DataMember]
		public string State { get; set; }
		[DataMember]
		public string SystemName { get; set; }
		[DataMember]
		public string SiteType { get; set; }
		[DataMember]
		public GetConsultsForPatientRespDataSources1 GetConsultsForPatientRespDataSources1Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespDataSources1
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetConsultsForPatientRespItems1MultipleResponse[] GetConsultsForPatientRespItems1Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault16 GetConsultsForPatientRespFault16Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespItems1MultipleResponse
	{
		[DataMember]
		public string Protocol { get; set; }
		[DataMember]
		public string Modality { get; set; }
		[DataMember]
		public int Timeout { get; set; }
		[DataMember]
		public int Port { get; set; }
		[DataMember]
		public string Provider { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Description { get; set; }
		[DataMember]
		public string Context { get; set; }
		[DataMember]
		public bool TestSource { get; set; }
		[DataMember]
		public string Vendor { get; set; }
		[DataMember]
		public string Version { get; set; }
		[DataMember]
		public string WelcomeMessage { get; set; }
		[DataMember]
		public GetConsultsForPatientRespSiteId1 GetConsultsForPatientRespSiteId1Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault15 GetConsultsForPatientRespFault15Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespSiteId1
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetConsultsForPatientRespTaggedResults8MultipleResponse[] GetConsultsForPatientRespTaggedResults8Info { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault14 GetConsultsForPatientRespFault14Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespTaggedResults8MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault14
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault15
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault16
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault17
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault18
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespAvailability
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetConsultsForPatientRespSlotsMultipleResponse[] GetConsultsForPatientRespSlotsInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault20 GetConsultsForPatientRespFault20Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespSlotsMultipleResponse
	{
		[DataMember]
		public string Start { get; set; }
		[DataMember]
		public string End { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public bool Available { get; set; }
		[DataMember]
		public GetConsultsForPatientRespFault19 GetConsultsForPatientRespFault19Info { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientRespFault19
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault20
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault21
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault22
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault23
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetConsultsForPatientRespFault24
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }
}