using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.CancelAppointmentResponseMessage)]
	[DataContract]
	public class CancelAppointmentResponseMessage : MessageBase
	{
		[DataMember]
		public CancelApptRespCancelAppointmentTo CancelApptRespCancelAppointmentToInfo { get; set; }
		[DataMember]
		public bool ExceptionOccured { get; set; }
		[DataMember]
		public string ExceptionMessage { get; set; }
        [DataMember]
        public string SerializedInstance { get; set; }
        [DataMember]
        public string VimtRequest { get; set; }
        [DataMember]
        public string VimtResponse { get; set; }

        //TO DO - get EC response object to pass back into the plugin - add this as an attribute of the response message
    }

    [DataContract]
	public class CancelApptRespCancelAppointmentTo
	{
		[DataMember]
		public string Timestamp { get; set; }
		[DataMember]
		public string Purpose { get; set; }
		[DataMember]
		public string Reason { get; set; }
		[DataMember]
		public string Remarks { get; set; }
		[DataMember]
		public CancelApptRespClinic CancelApptRespClinicInfo { get; set; }
		[DataMember]
		public CancelApptRespFault16 CancelApptRespFault16Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespClinic
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Building { get; set; }
		[DataMember]
		public string Floor { get; set; }
		[DataMember]
		public string Room { get; set; }
		[DataMember]
		public string Bed { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string AppointmentTimestamp { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string PhysicalLocation { get; set; }
		[DataMember]
		public bool AskForCheckIn { get; set; }
		[DataMember]
		public bool AskForCheckInSpecified { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string ClinicDisplayStartTime { get; set; }
		[DataMember]
		public string DisplayIncrements { get; set; }
		[DataMember]
		public string MaxOverbooksPerDay { get; set; }
		[DataMember]
		public string ProhibitAccessToClinic { get; set; }
		[DataMember]
		public CancelApptRespDepartment CancelApptRespDepartmentInfo { get; set; }
		[DataMember]
		public CancelApptRespService CancelApptRespServiceInfo { get; set; }
		[DataMember]
		public CancelApptRespSpecialty CancelApptRespSpecialtyInfo { get; set; }
		[DataMember]
		public CancelApptRespStopCode CancelApptRespStopCodeInfo { get; set; }
		[DataMember]
		public CancelApptRespCreditStopCode CancelApptRespCreditStopCodeInfo { get; set; }
		[DataMember]
		public CancelApptRespFacility CancelApptRespFacilityInfo { get; set; }
		[DataMember]
		public CancelApptRespAvailability CancelApptRespAvailabilityInfo { get; set; }
		[DataMember]
		public CancelApptRespFault15 CancelApptRespFault15Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespDepartment
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public CancelApptRespTaggedResultsMultipleResponse[] CancelApptRespTaggedResultsInfo { get; set; }
		[DataMember]
		public CancelApptRespFault CancelApptRespFaultInfo { get; set; }
	}

	[DataContract]
	public class CancelApptRespTaggedResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class CancelApptRespFault
	{
		[DataMember]
		public string InnerMessage { get; set; }
		[DataMember]
		public string InnerStackTrace { get; set; }
		[DataMember]
		public string InnerType { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string StackTrace { get; set; }
		[DataMember]
		public string Suggestion { get; set; }
		[DataMember]
		public string Type { get; set; }
	}

	[DataContract]
	public class CancelApptRespService
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public CancelApptRespTaggedResults1MultipleResponse[] CancelApptRespTaggedResults1Info { get; set; }
		[DataMember]
		public CancelApptRespFault1 CancelApptRespFault1Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespTaggedResults1MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class CancelApptRespFault1
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespSpecialty
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public CancelApptRespTaggedResults2MultipleResponse[] CancelApptRespTaggedResults2Info { get; set; }
		[DataMember]
		public CancelApptRespFault2 CancelApptRespFault2Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespTaggedResults2MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class CancelApptRespFault2
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespStopCode
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public CancelApptRespTaggedResults3MultipleResponse[] CancelApptRespTaggedResults3Info { get; set; }
		[DataMember]
		public CancelApptRespFault3 CancelApptRespFault3Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespTaggedResults3MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class CancelApptRespFault3
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespCreditStopCode
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public CancelApptRespTaggedResults4MultipleResponse[] CancelApptRespTaggedResults4Info { get; set; }
		[DataMember]
		public CancelApptRespFault4 CancelApptRespFault4Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespTaggedResults4MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class CancelApptRespFault4
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFacility
	{
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string DisplayName { get; set; }
		[DataMember]
		public string Moniker { get; set; }
		[DataMember]
		public string RegionId { get; set; }
		[DataMember]
		public string LastEventTimestamp { get; set; }
		[DataMember]
		public string LastEventReason { get; set; }
		[DataMember]
		public string Uid { get; set; }
		[DataMember]
		public string Pid { get; set; }
		[DataMember]
		public string ParentSiteId { get; set; }
		[DataMember]
		public string Address { get; set; }
		[DataMember]
		public string City { get; set; }
		[DataMember]
		public string State { get; set; }
		[DataMember]
		public string SystemName { get; set; }
		[DataMember]
		public string SiteType { get; set; }
		[DataMember]
		public CancelApptRespDataSources CancelApptRespDataSourcesInfo { get; set; }
		[DataMember]
		public CancelApptRespChildSites CancelApptRespChildSitesInfo { get; set; }
		[DataMember]
		public CancelApptRespFault12 CancelApptRespFault12Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespDataSources
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public CancelApptRespItemsMultipleResponse[] CancelApptRespItemsInfo { get; set; }
		[DataMember]
		public CancelApptRespFault7 CancelApptRespFault7Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespItemsMultipleResponse
	{
		[DataMember]
		public string Protocol { get; set; }
		[DataMember]
		public string Modality { get; set; }
		[DataMember]
		public int Timeout { get; set; }
		[DataMember]
		public int Port { get; set; }
		[DataMember]
		public string Provider { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Description { get; set; }
		[DataMember]
		public string Context { get; set; }
		[DataMember]
		public bool TestSource { get; set; }
		[DataMember]
		public string Vendor { get; set; }
		[DataMember]
		public string Version { get; set; }
		[DataMember]
		public string WelcomeMessage { get; set; }
		[DataMember]
		public CancelApptRespSiteId CancelApptRespSiteIdInfo { get; set; }
		[DataMember]
		public CancelApptRespFault6 CancelApptRespFault6Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespSiteId
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public CancelApptRespTaggedResults5MultipleResponse[] CancelApptRespTaggedResults5Info { get; set; }
		[DataMember]
		public CancelApptRespFault5 CancelApptRespFault5Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespTaggedResults5MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class CancelApptRespFault5
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault6
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault7
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespChildSites
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public CancelApptRespSitesMultipleResponse[] CancelApptRespSitesInfo { get; set; }
		[DataMember]
		public CancelApptRespFault11 CancelApptRespFault11Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespSitesMultipleResponse
	{
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string DisplayName { get; set; }
		[DataMember]
		public string Moniker { get; set; }
		[DataMember]
		public string RegionId { get; set; }
		[DataMember]
		public string LastEventTimestamp { get; set; }
		[DataMember]
		public string LastEventReason { get; set; }
		[DataMember]
		public string Uid { get; set; }
		[DataMember]
		public string Pid { get; set; }
		[DataMember]
		public string ParentSiteId { get; set; }
		[DataMember]
		public string Address { get; set; }
		[DataMember]
		public string City { get; set; }
		[DataMember]
		public string State { get; set; }
		[DataMember]
		public string SystemName { get; set; }
		[DataMember]
		public string SiteType { get; set; }
		[DataMember]
		public CancelApptRespDataSources1 CancelApptRespDataSources1Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespDataSources1
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public CancelApptRespItems1MultipleResponse[] CancelApptRespItems1Info { get; set; }
		[DataMember]
		public CancelApptRespFault10 CancelApptRespFault10Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespItems1MultipleResponse
	{
		[DataMember]
		public string Protocol { get; set; }
		[DataMember]
		public string Modality { get; set; }
		[DataMember]
		public int Timeout { get; set; }
		[DataMember]
		public int Port { get; set; }
		[DataMember]
		public string Provider { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Description { get; set; }
		[DataMember]
		public string Context { get; set; }
		[DataMember]
		public bool TestSource { get; set; }
		[DataMember]
		public string Vendor { get; set; }
		[DataMember]
		public string Version { get; set; }
		[DataMember]
		public string WelcomeMessage { get; set; }
		[DataMember]
		public CancelApptRespSiteId1 CancelApptRespSiteId1Info { get; set; }
		[DataMember]
		public CancelApptRespFault9 CancelApptRespFault9Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespSiteId1
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public CancelApptRespTaggedResults6MultipleResponse[] CancelApptRespTaggedResults6Info { get; set; }
		[DataMember]
		public CancelApptRespFault8 CancelApptRespFault8Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespTaggedResults6MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class CancelApptRespFault8
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault9
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault10
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault11
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault12
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespAvailability
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public CancelApptRespSlotsMultipleResponse[] CancelApptRespSlotsInfo { get; set; }
		[DataMember]
		public CancelApptRespFault14 CancelApptRespFault14Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespSlotsMultipleResponse
	{
		[DataMember]
		public string Start { get; set; }
		[DataMember]
		public string End { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public bool Available { get; set; }
		[DataMember]
		public CancelApptRespFault13 CancelApptRespFault13Info { get; set; }
	}

	[DataContract]
	public class CancelApptRespFault13
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault14
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault15
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class CancelApptRespFault16
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }
}