using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
	[Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.CancelAppointmentRequestMessage)]
	[DataContract]
	public class CancelAppointmentRequestMessage : MessageBase
	{
		[DataMember]
		public string OrganizationName { get; set; }
		[DataMember]
		public Guid UserId { get; set; }
		[DataMember]
		public Guid RelatedParentId { get; set; }
		[DataMember]
		public string RelatedParentEntityName { get; set; }
		[DataMember]
		public string RelatedParentFieldName { get; set; }
		[DataMember]
		public bool LogTiming { get; set; }
		[DataMember]
		public bool LogSoap { get; set; }
		[DataMember]
		public bool Debug { get; set; }
        [DataMember]
        public bool LogRequest { get; set; }
        [DataMember]
        public Guid AppointmentId { get; set; }
        [DataMember]
        public List<Guid> CanceledPatients { get; set; }
        [DataMember]
        public bool WholeAppointmentCanceled { get; set; }
        [DataMember]
		public CancelApptReqQueryBean CancelApptReqQueryBeanInfo { get; set; }
		[DataMember]
		public CancelApptReqAppointment CancelApptReqAppointmentInfo { get; set; }
	}

	[DataContract]
	public class CancelApptReqQueryBean
	{
		[DataMember]
		public string RecordSiteCode { get; set; }
		[DataMember]
		public string RequestingApp { get; set; }
		[DataMember]
		public string Active { get; set; }
		[DataMember]
		public string EndDate { get; set; }
		[DataMember]
		public string StartDate { get; set; }
		[DataMember]
		public string MaxRecords { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string SupplementalParameters { get; set; }
		[DataMember]
		public string ItemId { get; set; }
		[DataMember]
		public string Target { get; set; }
		[DataMember]
		public string Criteria { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string Direction { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public bool MultiSiteQuery { get; set; }
		[DataMember]
		public string ConsumingAppToken { get; set; }
		[DataMember]
		public string ConsumingAppPassword { get; set; }
		[DataMember]
		public CancelApptReqProvider CancelApptReqProviderInfo { get; set; }
		[DataMember]
		public CancelApptReqPatient CancelApptReqPatientInfo { get; set; }
	}

	[DataContract]
	public class CancelApptReqProvider
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string UserId { get; set; }
		[DataMember]
		public string LoginSiteCode { get; set; }
		[DataMember]
		public string ContextMenu { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
	}

	[DataContract]
	public class CancelApptReqPatient
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string LocalPid { get; set; }
		[DataMember]
		public string LocalSiteId { get; set; }
		[DataMember]
		public string MpiPid { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
		[DataMember]
		public string Ss { get; set; }
		[DataMember]
		public string InPatient { get; set; }
		[DataMember]
		public string Age { get; set; }
		[DataMember]
		public string Gender { get; set; }
		[DataMember]
		public string ScPercentage { get; set; }
	}

	[DataContract]
	public class CancelApptReqAppointment
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Timestamp { get; set; }
		[DataMember]
		public string Title { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string LabDateTime { get; set; }
		[DataMember]
		public string XrayDateTime { get; set; }
		[DataMember]
		public string EkgDateTime { get; set; }
		[DataMember]
		public string Purpose { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string CurrentStatus { get; set; }
		[DataMember]
		public string ClinicId { get; set; }
		[DataMember]
		public string AppointmentTimestamp { get; set; }
		[DataMember]
		public string PurposeSubcategory { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string AppointmentType { get; set; }
		[DataMember]
		public string BookNotes { get; set; }
		[DataMember]
		public string ConsultIen { get; set; }
		[DataMember]
		public string Lvl { get; set; }
		[DataMember]
		public string DesiredDateTime { get; set; }
		[DataMember]
		public string VisitId { get; set; }
		[DataMember]
		public string ProviderName { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string CancelCode { get; set; }
		[DataMember]
		public string CancelReason { get; set; }
		[DataMember]
		public string Remarks { get; set; }
		[DataMember]
		public CancelApptReqFacility CancelApptReqFacilityInfo { get; set; }
		[DataMember]
		public CancelApptReqClinic CancelApptReqClinicInfo { get; set; }
	}

	[DataContract]
	public class CancelApptReqFacility
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string LastEvent { get; set; }
		[DataMember]
		public string LastSeenDate { get; set; }
		[DataMember]
		public string Name { get; set; }
	}

	[DataContract]
	public class CancelApptReqClinic
	{
		[DataMember]
		public string Abbr { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string AppointmentTimestamp { get; set; }
		[DataMember]
		public bool AskForCheckIn { get; set; }
		[DataMember]
		public bool AskForCheckInSpecified { get; set; }
		[DataMember]
		public string Bed { get; set; }
		[DataMember]
		public string Building { get; set; }
		[DataMember]
		public string DisplayIncrements { get; set; }
		[DataMember]
		public string DispositionAction { get; set; }
		[DataMember]
		public string Floor { get; set; }
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string MaxOverbooksPerDay { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string PhysicalLocation { get; set; }
		[DataMember]
		public string ProhibitAccessToClinic { get; set; }
		[DataMember]
		public string Room { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string VisitLocation { get; set; }
		[DataMember]
		public string SiteId { get; set; }
		[DataMember]
		public CancelApptReqAvailabilityMultipleResponse[] CancelApptReqAvailabilityInfo { get; set; }
		[DataMember]
		public CancelApptReqCreditStopCode CancelApptReqCreditStopCodeInfo { get; set; }
		[DataMember]
		public CancelApptReqDepartment CancelApptReqDepartmentInfo { get; set; }
		[DataMember]
		public CancelApptReqDivision CancelApptReqDivisionInfo { get; set; }
		[DataMember]
		public CancelApptReqFacility1 CancelApptReqFacility1Info { get; set; }
		[DataMember]
		public CancelApptReqInstitution CancelApptReqInstitutionInfo { get; set; }
		[DataMember]
		public CancelApptReqModule CancelApptReqModuleInfo { get; set; }
		[DataMember]
		public CancelApptReqPrincipalClinic CancelApptReqPrincipalClinicInfo { get; set; }
		[DataMember]
		public CancelApptReqService CancelApptReqServiceInfo { get; set; }
		[DataMember]
		public CancelApptReqSpecialty CancelApptReqSpecialtyInfo { get; set; }
		[DataMember]
		public CancelApptReqStopCode CancelApptReqStopCodeInfo { get; set; }
		[DataMember]
		public CancelApptReqTypeExtension CancelApptReqTypeExtensionInfo { get; set; }
		[DataMember]
		public CancelApptReqWardLocation CancelApptReqWardLocationInfo { get; set; }
		[DataMember]
		public CancelApptReqFault CancelApptReqFaultInfo { get; set; }
	}

	[DataContract]
	public class CancelApptReqAvailabilityMultipleResponse
	{
		[DataMember]
		public bool Available { get; set; }
		[DataMember]
		public string End { get; set; }
		[DataMember]
		public string Start { get; set; }
		[DataMember]
		public string Text { get; set; }
	}

	[DataContract]
	public class CancelApptReqCreditStopCode
	{
		[DataMember]
		public object Key { get; set; }
		[DataMember]
		public object Value { get; set; }
	}

	[DataContract]
	public class CancelApptReqDepartment
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqDivision
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqFacility1
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string LastEvent { get; set; }
		[DataMember]
		public string LastSeenDate { get; set; }
		[DataMember]
		public string Name { get; set; }
	}

	[DataContract]
	public class CancelApptReqInstitution
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqModule
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqPrincipalClinic
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqService
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqSpecialty
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqStopCode
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqTypeExtension
	{
        [DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqWardLocation
	{
		[DataMember]
        public object Key { get; set; }
        [DataMember]
        public object Value { get; set; }
    }

	[DataContract]
	public class CancelApptReqFault
	{
		[DataMember]
		public string InnerMessage { get; set; }
		[DataMember]
		public string InnerStackTrace { get; set; }
		[DataMember]
		public string InnerType { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string StackTrace { get; set; }
		[DataMember]
		public string Suggestion { get; set; }
		[DataMember]
		public string Type { get; set; }
	}
}