﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom
{
    /// <summary>
    /// VIMT message for VmrOnDemandCreateRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VmrOnDemandCreateRequestMessage)]
    [DataContract]
    public class VmrOnDemandCreateRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log requests.
        /// </summary>
        [DataMember]
        public bool LogRequest { get; set; }

        /// <summary>
        /// Gets or sets the Video On Demand Id.
        /// </summary>
        [DataMember]
        public Guid VideoOnDemandId { get; set; }

        /// <summary>
        /// Gets or sets the Patient Id.
        /// </summary>
        [DataMember]
        public Guid PatientId { get; set; }

        /// <summary>
        /// Gets or sets the Provider Id.
        /// </summary>
        [DataMember]
        public Guid ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the Misc Flag.
        /// </summary>
        [DataMember]
        public string MiscData { get; set; }
    }
}