﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.VideoVisit
{
    /// <summary>
    /// VIMT message for VideoVisitUpdateRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VideoVisitUpdateRequestMessage)]
    [DataContract]
    public class VideoVisitUpdateRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log requests.
        /// </summary>
        [DataMember]
        public bool LogRequest { get; set; }

        /// <summary>
        /// Gets or sets the Service Appointment Id.
        /// </summary>
        [DataMember]
        public Guid AppointmentId { get; set; }

        /// <summary>
        /// Full list of patients being booked - including previously booked
        /// </summary>
        [DataMember]
        public List<Guid> Contacts { get; set; }
    }
}