﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.CRM;
using VA.TMP.DataModel;
using VA.TMP.Integration.Plugins.Messages;
using VRMRest;

namespace VA.TMP.Integration.Plugins
{
    public class TestVIMTHandlerPluginRunner : PluginRunner
    {
        public TestVIMTHandlerPluginRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }

        public override string McsSettingsDebugField
        {
            get
            {
                return "mcs_serviceplugin";
            }
        }

        public override void Execute()
        {
            object response;
            object request;
            var thisRecord = PrimaryEntity.ToEntity<Account>();
            var handler = thisRecord.Name;
            var uri = string.Empty;
            using (var srv = new Xrm(OrganizationService))
            {
                var uriObj = srv.mcs_integrationsettingSet.FirstOrDefault(x => x.mcs_name == "VIMT URL");
                uri = uriObj.mcs_value;
            }
            switch (handler)
            {
                case "cancel":
                    request = new CancelAppointmentRequestMessage
                    {
                        UserId = PluginExecutionContext.UserId,
                        OrganizationName = PluginExecutionContext.OrganizationName
                    };
                    try
                    {
                        Logger.WriteDebugMessage("Call VIMT");
                        response = Utility.SendReceive<CancelAppointmentResponseMessage>(new Uri(uri), MessageRegistry.CancelAppointmentRequestMessage, request, null);
                        Logger.WriteDebugMessage("Finished VIMT");
                    } 
                    catch (Exception ex)
                    {
                        Logger.WriteToFile(CvtHelper.BuildExceptionMessage(ex));
                    }
                    break;
                case "book":
                    request = new MakeAppointmentRequestMessage
                    {
                        UserId = PluginExecutionContext.UserId,
                        OrganizationName = PluginExecutionContext.OrganizationName,
                        LogRequest = true
                    };
                    try
                    {
                        Logger.WriteDebugMessage("Call VIMT MakeAppt");
                        response = Utility.SendReceive<MakeAppointmentResponseMessage>(new Uri(uri), MessageRegistry.MakeAppointmentRequestMessage, request, null);
                        Logger.WriteDebugMessage("Finished VIMT MakeAppt");
                    } 
                    catch (Exception ex)
                    {
                        Logger.WriteToFile(CvtHelper.BuildExceptionMessage(ex));
                    }

                    break;
                case "consults":
                    request = new GetConsultsRequestMessage
                    {
                        UserId = PluginExecutionContext.UserId,
                        OrganizationName = PluginExecutionContext.OrganizationName,
                        LogRequest = true
                    };
                    try
                    {
                        Logger.WriteDebugMessage("Call VIMT GetConsult");
                        response = Utility.SendReceive<MakeAppointmentResponseMessage>(new Uri(uri), MessageRegistry.MakeAppointmentRequestMessage, request, null);
                        Logger.WriteDebugMessage("Finished VIMT GetConsult");
                    }
                    catch (Exception ex)
                    {
                        Logger.WriteToFile(CvtHelper.BuildExceptionMessage(ex));
                    }
                    break;
                default:
                    Logger.WriteDebugMessage("No VIMT call found: " + handler);
                    break;
            }
            throw new InvalidPluginExecutionException("Plugin Fired");
        }
    }
}
