﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using MCSShared;
using VA.TMP.CRM;
using VA.TMP.Integration.Plugins.Messages;
using Microsoft.Xrm.Sdk.Query;
using VA.TMP.Integration.Plugins.Shared;
using VA.TMP.OptionSets;

namespace VA.TMP.Integration.Plugins.CrmePerson
{
    public class CrmePersonRetrieveMultiplePostGetConsultsRunner : PluginRunner
    {
        public CrmePersonRetrieveMultiplePostGetConsultsRunner(IServiceProvider serviceProvider) : base(serviceProvider)
        {

        }
        public override string McsSettingsDebugField
        {
            get
            {
                return "crme_person";
                // throw new NotImplementedException();
            }
        }

        public override void Execute()
        {
            try
            {
                var qe = (QueryExpression)PluginExecutionContext.InputParameters["Query"];
                int integrationTypeValue;
                PersonSearchPluginUtilities.TryGetConditionOptionSet(qe, "cvt_IntegrationType", out integrationTypeValue);
                if (integrationTypeValue != (int)crme_personcvt_IntegrationType.GetConsultsForPatient) //Change to Option Set
                    return;

                Logger.WriteToFile("Populating Request");
                List<Guid> providerIds = new List<Guid>();
                List<Guid> patientIds = new List<Guid>();

                providerIds.Add(new Guid("F3D8EA62-C766-E311-9E25-00155D559835"));
                patientIds.Add(new Guid("749E4ADA-2A72-E611-80DB-000D3A007BF6"));
                var request = new GetConsultsForPatientRequest
                {
                    Debug = true,
                    ProviderIds = providerIds,
                    PatientIds = patientIds,
                    PatLoginSiteCode = "666",
                    ProLoginSiteCode = "500",
                    LogRequest=true,
                    UserId=PluginExecutionContext.UserId,
                    OrganizationName=PluginExecutionContext.OrganizationName
                };
                var Response = VRMRest.Utility.SendReceive<GetConsultsForPatientResponse>(new Uri("http://localhost:8085"), MessageRegistry.GetConsultsForPatientRequest, request, null);
                Logger.WriteToFile("Sent Request To VIMT");
                var mappedResponse = MapResponseToCrm(Response);
                ((EntityCollection)PluginExecutionContext.OutputParameters["BusinessEntityCollection"]).Entities.AddRange(mappedResponse);
            }
            catch (Exception ex)
            {
                throw new InvalidPluginExecutionException(ex.Message);
            }

            //[DataMember]
            //public List<Guid> ProviderIds { get; set; }

            //[DataMember]
            //public List<Guid> PatientIds { get; set; }


            //[DataMember]
            //public string PatLoginSiteCode { get; set; }

            //[DataMember]
            //public string ProLoginSiteCode { get; set; }

        }

        
        public List<DataModel.crme_person> MapResponseToCrm(GetConsultsForPatientResponse response)
        {
            if (response == null)
                return null;
            var persons = new List<DataModel.crme_person>();
            if (response.PatGetConsultsForPatientRespTaggedConsultArraysInfo != null && response.PatGetConsultsForPatientRespTaggedConsultArraysInfo.Count > 0)
            {
                var patPersons = MapResponse(response.PatGetConsultsForPatientRespTaggedConsultArraysInfo, "patient");
                persons.AddRange(patPersons);
            }
            if (response.ProGetConsultsForPatientRespTaggedConsultArraysInfo != null &&
                response.ProGetConsultsForPatientRespTaggedConsultArraysInfo.Count > 0)
            {
                var proPersons = MapResponse(response.ProGetConsultsForPatientRespTaggedConsultArraysInfo, "provider");
                persons.AddRange(proPersons);
            }
            return persons;
        }

        public List<DataModel.crme_person> MapResponse(GetConsultsForPatientRespTaggedConsultArrays responseConsultsArray, string side)
        {
            var persons = new List<DataModel.crme_person>();
            if (responseConsultsArray.GetConsultsForPatientRespArraysInfo != null)
            {
                foreach(var arr in responseConsultsArray.GetConsultsForPatientRespArraysInfo)
                {
                    if (arr != null && arr.GetConsultsForPatientRespConsultsInfo != null)
                    {
                        foreach(var consult in arr.GetConsultsForPatientRespConsultsInfo)
                        {
                            var person = new DataModel.crme_person
                            {
                                cvt_ConsultIEN = consult.Id,
                                cvt_ConsultStatus = consult.Status,
                                cvt_ConsultText = consult.Text,
                                cvt_ConsultTimestamp = consult.Timestamp,
                                cvt_ConsultTitle = consult.Title,
                                Id = new Guid(),
                                crme_url = side //arbitrarily using this variable to temporarily send the pat/pro string across to the js
                            };
                            persons.Add(person);
                        }
                    }
                }
            }
            return persons;
        }
        
    }
}
