﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Xml.Linq;
using System.Xml.Schema;
using System.Xml.Serialization;
using VA.TMP.Integration.Schema.VideoVisitService;
using VA.TMP.Integration.Schema.VirtualMeetingRoom;

namespace SchemaTester
{
    internal class Program
    {
        private static void Main()
        {
            try
            {
                RunVyoptaSchema();
                Console.WriteLine(Environment.NewLine);
                Console.WriteLine(Environment.NewLine);
                RunVyoptaSchemaDelete();
                Console.WriteLine(Environment.NewLine);
                Console.WriteLine(Environment.NewLine);
                RunVideoVisitSchema();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
            finally
            {
                Console.ReadLine();
            }
        }

        private static void RunVyoptaSchema()
        {
            var virtualMeetingRoom = new VirtualMeetingRoomType
            {
                Version = "1.0",
                AppointmentId = Guid.NewGuid().ToString(),
                PatientName = Guid.NewGuid().ToString(),
                ProviderName = Guid.NewGuid().ToString(),
                MeetingRoomName = "CVT01234",
                PatientPin = "9876543",
                ProviderPin = "0123456",
                StartDate = DateTime.UtcNow,
                EndDate = DateTime.UtcNow.Add(new TimeSpan(2, 0, 0)),
                MiscData = string.Empty
            };

            var result = SerializeIntance(virtualMeetingRoom, new List<string> { "vmr" },
                new List<string> { "http://va.gov/vyopta/schemas/exchange/VirtualMeetingRoom/1.0" });

            ValidateSchema(@"C:\src\CVT-TSS\VA.TMP.Integration\VA.TMP.Integration.Schema.VirtualMeetingRoom",
                new List<string> { "http://va.gov/vyopta/schemas/exchange/VirtualMeetingRoom/1.0" },
                new List<string> { "VirtualMeetingRoom.xsd" },
                result);

            Console.WriteLine(result);
        }

        private static void RunVyoptaSchemaDelete()
        {
            var virtualMeetingRoom = new VirtualMeetingRoomDeleteType
            {
                Version = "1.0",
                AppointmentId = Guid.NewGuid().ToString(),
                MiscData = string.Empty
            };

            var result = SerializeIntance(virtualMeetingRoom, new List<string> { "vmr" },
                new List<string> { "http://va.gov/vyopta/schemas/exchange/VirtualMeetingRoom/1.0" });

            ValidateSchema(@"C:\src\CVT-TSS\VA.TMP.Integration\VA.TMP.Integration.Schema.VirtualMeetingRoom",
                new List<string> { "http://va.gov/vyopta/schemas/exchange/VirtualMeetingRoom/1.0" },
                new List<string> { "VirtualMeetingRoom.xsd" },
                result);

            Console.WriteLine(result);
        }

        private static void RunVideoVisitSchema()
        {
            var appointment = new Appointment
            {
                Version = "1.0",
                Id = "uuid",
                Patients = new Patients
                {
                    Patient = new List<Patient>
                    {
                        new Patient
                        {
                            Id = new PersonIdentifier { AssigningAuthority = "ICN", UniqueId = "1016433599V285591" },
                            Name = new PersonName { FirstName = "PatientOneFirstName", LastName = "PatientOneLastName" },
                            ContactInformation = new ContactInformation { PreferredEmail = "apatientone@microsoft.com", TimeZone = 35 },
                            Location = new Location { Type = LocationType.NonVA },
                            VirtualMeetingRoom = new VirtualMeetingRoom { Conference = "testVAVMR@pexip.com", Pin = "1234", Url = "http://care.va.gov/vmr" }
                        },
                        new Patient
                        {
                            Id = new PersonIdentifier { AssigningAuthority = "ICN", UniqueId = "1016433599V285592" },
                            Name = new PersonName { FirstName = "PatientTwoFirstName", LastName = "PatientTwoLastName" },
                            ContactInformation = new ContactInformation { PreferredEmail = "apatienttwo@microsoft.com", TimeZone = 35 },
                            Location = new Location { Type = LocationType.NonVA },
                            VirtualMeetingRoom = new VirtualMeetingRoom { Conference = "testVAVMR@pexip.com", Pin = "3456", Url = "http://care.va.gov/vmr" }
                        }
                    }
                },
                Duration = 30,
                DateTime = DateTime.Parse("2001-12-31T12:00:00"),
                SchedulingRequestType = SchedulingRequestType.OTHER_THAN_NEXT_AVAILABLE_PATIENT_REQUESTED,
                Type = AppointmentType.REGULAR,
                BookingNotes = "BookingNotes",
                DesiredDate = DateTime.Parse("2001-12-31T12:00:00"),
                Providers = new Providers
                {
                    Provider = new List<Provider>
                    {
                        new Provider
                        {
                            Name = new PersonName { FirstName = "DoctorOneFirstName", LastName = "DoctorOneLastName" },
                            Id = new PersonIdentifier { AssigningAuthority = "IEN", UniqueId = "10164" },
                            ContactInformation = new ContactInformation { PreferredEmail = "PII               ", TimeZone = 35 },
                            VirtualMeetingRoom = new VirtualMeetingRoom { Conference = "testVAVMR@pexip.com", Pin = "2345", Url = "http://care.va.gov/vmr" },
                            Location = new Location
                            {
                                Type = LocationType.VA,
                                Facility = new Facility {SiteCode = "688", Name = "Washington DC"},
                                Clinic = new Clinic {Ien = "IEN", Name = "Doctor's Office" }
                            }
                        },
                        new Provider
                        {
                            Name = new PersonName { FirstName = "DoctorTwoFirstName", LastName = "DoctorTwoLastName" },
                            Id = new PersonIdentifier { AssigningAuthority = "IEN", UniqueId = "10165" },
                            ContactInformation = new ContactInformation { PreferredEmail = "PII               ", TimeZone = 35 },
                            VirtualMeetingRoom = new VirtualMeetingRoom { Conference = "testVAVMR@pexip.com", Pin = "5678", Url = "http://care.va.gov/vmr" },
                            Location = new Location
                            {
                                Type = LocationType.VA,
                                Facility = new Facility {SiteCode = "688", Name = "Washington DC"},
                                Clinic = new Clinic {Ien = "IEN", Name = "Doctor's Office" }
                            }
                        }
                    }
                }
            };

            var result = SerializeIntance(appointment, new List<string> { "p" },
                new List<string> { "https://staff.mobilehealth.va.gov/vamf/video-visits/1.0" });

            ValidateSchema(@"C:\src\CVT-TSS\VA.TMP.Integration\VA.TMP.Integration.Schema.VideoVisitService",
                new List<string> { "https://staff.mobilehealth.va.gov/vamf/video-visits/1.0" },
                new List<string> { "Appointment.xsd" },
                result);

            Console.WriteLine(result);
        }

        public static string SerializeIntance<T>(T examRequestContention, List<string> prefixes, List<string> namespaces)
        {
            using (var stream = new MemoryStream())
            {
                var serializer = new XmlSerializer(typeof(T));

                var ns = new XmlSerializerNamespaces();

                for (var i = 0; i < prefixes.Count; i++)
                {
                    ns.Add(prefixes[i], namespaces[i]);
                }

                serializer.Serialize(stream, examRequestContention, ns);
                return Encoding.ASCII.GetString(stream.ToArray());
            }
        }

        private static void ValidateSchema(string schemaPath, List<string> namespaces, List<string> schemaFileNames, string xml)
        {
            var schemas = new XmlSchemaSet();


            for (var i = 0; i < namespaces.Count; i++)
            {
                schemas.Add(namespaces[i], Path.Combine(schemaPath, schemaFileNames[i]));
            }

            var examStatusUpdateXml = XDocument.Parse(xml);
            var schemaValidationMessage = string.Empty;
            examStatusUpdateXml.Validate(schemas, (o, err) => { schemaValidationMessage = err.Message; });

            if (!string.IsNullOrEmpty(schemaValidationMessage))
            {
                throw new Exception(string.Format("Virtual Meeting Room Schema Validation Error: {0}", schemaValidationMessage));
            }
        }
    }
}