﻿using Microsoft.Xrm.Sdk;
using System;
using System.Linq;
using VA.TMP.DataModel;

namespace VA.TMP.CRM
{
    public class McsSiteDeletePreStageRunner : PluginRunner
    {
        #region Constructor
        public McsSiteDeletePreStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        #region Internal Methods/Properties
        public override void Execute()
        {
            DeleteSite(PluginExecutionContext.PrimaryEntityId);
        }

        internal void DeleteSite(Guid thisId)
        {
            Logger.WriteDebugMessage("Starting Delete System Site");
           
            using (var srv = new Xrm(OrganizationService))
            {
                //Starting Validation Checks before deleting the MCS Resource & System Resource. 
                Logger.setMethod = "Delete Sytem Resource";
                //Checking to see if a System Resource Exists for the target MCS Resource being deleted. 
              //  var systemEquip = srv.EquipmentSet.FirstOrDefault(i => i.Id ==
              //      McsHelper.getEntRefID("mcs_relatedresourceid"));

                var mcsSite = srv.mcs_siteSet.FirstOrDefault(i => i.Id == thisId);
                var systemSite = srv.SiteSet.FirstOrDefault(i => i.Id == mcsSite.mcs_RelatedActualSiteId.Id);

                

                var siteTeam = srv.TeamSet.FirstOrDefault(i => i.Name == mcsSite.mcs_name );
                if (siteTeam != null)
                {
                    Logger.WriteDebugMessage("Attempting to Delete Site Team");
                    OrganizationService.Delete(siteTeam.LogicalName , siteTeam.Id);
                    Logger.WriteDebugMessage(siteTeam.Name + " Site Team has been deleted.");
                }


                //If a System Resource does not exist, we will return because the Plugin will have nothing to delete. 
                if (systemSite == null)
                    return;
                Logger.WriteDebugMessage("Got System Site:" + systemSite.Name);
               
                //Checking to see if any Resources have this target MCS Site associated with it.
                var mcsResource = srv.mcs_resourceSet.FirstOrDefault(i => i.mcs_RelatedSiteId.Id == thisId);
                //If an associated Group Resource does exist, we will throw an exception with a message and stop the delete of the MCS Site, to prevent orphan data.
                if (mcsResource != null)
                {
                    Logger.WriteDebugMessage("Resource Exists:" + mcsResource.mcs_name);                                    
                    throw new InvalidPluginExecutionException("customPlease check Left Nav on Site form for Resources that this Site is associated with. Site cannot be deleted until associations are removed.");
                }

                //Checking to see if any Resources have this target MCS Site associated with it.
                var mtsa = srv.cvt_mastertsaSet.FirstOrDefault(i => i.cvt_RelatedSiteid.Id == thisId);
                //If an associated MTSA does exist, we will throw an exception with a message and stop the delete of the MCS Site, to prevent orphan dat
                if (mtsa != null)
                {
                    Logger.WriteDebugMessage("MTSA Exists:" + mtsa.cvt_name);
                    throw new InvalidPluginExecutionException("customPlease check Left Nav on Site form for Master TSA's that this Site is associated with. Site cannot be deleted until associations are removed.");
                }

                var tsa = srv.mcs_servicesSet.FirstOrDefault(i => i.cvt_relatedpatientsiteid.Id == thisId || i.cvt_relatedprovidersiteid.Id == thisId);
                //If an associated Group Resource does exist, we will throw an exception with a message and stop the delete of the MCS Site, to prevent orphan data.
                if (tsa != null)
                {
                    Logger.WriteDebugMessage("TSA Exists:" + tsa.mcs_name);
                    throw new InvalidPluginExecutionException("customPlease check Left Nav on Site form for TSA's that this Site is associated with. Site cannot be deleted until associations are removed.");
                }

                //If no exceptions are thrown from validation checks, we will actually delete the System Resource associated with the MCS Site.              
                OrganizationService.Delete(systemSite.LogicalName, systemSite.Id);               
                Logger.WriteDebugMessage("System Resource Deleted");
            }
          
        }
        #endregion

        #region Additional Interface Methods/Properties
        public override string McsSettingsDebugField
        {
            get { return "mcs_siteplugin"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.PreEntityImages["pre"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.PreEntityImages["pre"];
        }   
        #endregion
    }
}