﻿using MCSShared;
using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;

namespace VA.TMP.CRM
{
    public class EMailCreatePostStageRunner : PluginRunner
    {        
        public EMailCreatePostStageRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }
        //Declare global variables
        //string customMessage;

        #region Implementation
        /// <summary>
        /// Called by PluginRunner - Decide which email to send out (aka which branch of the plugin to run)
        /// </summary>
        public override void Execute()
        {
            Email email = (Email)OrganizationService.Retrieve(Email.EntityLogicalName.ToString(), PrimaryEntity.Id, new ColumnSet(true));
            if (email.Subject.StartsWith("FW:") || email.Subject.StartsWith("RE:"))
                return;
            Logger.WriteToFile(email.Subject);
            if (email.mcs_RelatedServiceActivity != null)
            {
                //Retrieve and Use relatedAppt and TSA throughout ServiceAppointment Email Execute Functions
                ServiceAppointment relatedAppt = (ServiceAppointment)OrganizationService.Retrieve(
                    ServiceAppointment.EntityLogicalName.ToString(), email.mcs_RelatedServiceActivity.Id, new ColumnSet(true));
                mcs_services tsa = (mcs_services)OrganizationService.Retrieve(mcs_services.EntityLogicalName, relatedAppt.mcs_relatedtsa.Id, new ColumnSet(true));
                var SAEmail = new ServiceAppointmentEmail(OrganizationService, Logger, email, relatedAppt, tsa);
                SAEmail.Execute();
            }
            if (email.RegardingObjectId != null)
            {
                if (email.RegardingObjectId.LogicalName == mcs_services.EntityLogicalName)
                {
                    var TsaEmail = new TsaEmail(OrganizationService, Logger, email);
                    TsaEmail.Execute();
                    Logger.WriteDebugMessage("Completed Send TSA Email");
                }
                else
                {
                    var privilegingEmail = new PrivilegingEmail(OrganizationService, Logger, email);
                    privilegingEmail.Execute();
                }
                Logger.WriteDebugMessage("Beginning Send Email");
            }
        }
        #endregion

        #region Debug Field for Logging
        public override string McsSettingsDebugField
        {
            get { return "cvt_serviceactivityplugin"; }
        }
        #endregion
    }
}
