﻿using Microsoft.Xrm.Sdk;
using System;
using VA.TMP.DataModel;

namespace VA.TMP.CRM
{
    /// <summary>
    /// If occurrences > 16, throw custom error to user.
    /// </summary>
    public class McsAppointmentMasterCreatePreStageRunner : PluginRunner
    {
        #region Constructor
        public McsAppointmentMasterCreatePreStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion
        #region Internal Methods
        public override void Execute()
        {
            var thisRecurringSeries = PrimaryEntity.ToEntity<RecurringAppointmentMaster>();
            CheckAttributes(thisRecurringSeries);
        }

        internal void CheckAttributes(Entity thisRecurringSeries)
        {
            Logger.setMethod = "CheckAttributes";
            Logger.WriteDebugMessage("Checking Recurring Series Attributes");

            using (var srv = new Xrm(OrganizationService))
            {
                var occurrences = McsHelper.getIntValue("occurrences");

                if (occurrences > 16)
                {
                    Logger.WriteDebugMessage("Too many occurrences");
                    throw new InvalidPluginExecutionException("customNumber of Occurrences cannot exceed 16 ");
                }
            }
        }
        #endregion
        #region Additional Interface Methods
        public override string McsSettingsDebugField
        {
            get { return "mcs_appointmentplugin"; }
        }
        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
        #endregion
    }
}