﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.Processor
{
    public class MakeAppointmentProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public IMessageBase Execute(MakeAppointmentRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<MakeAppointmentStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())

                .RegisterType<FilterBase<MakeAppointmentStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new MakeAppointmentStateObject(request))
            {
                new Pipeline<MakeAppointmentStateObject>()
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.MakeAppointmentResponseMessage;
            }
        }
    }
}
