﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsults;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.Processor
{
    public class GetConsultsProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public IMessageBase Execute(GetConsultsRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<GetConsultsStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())

                .RegisterType<FilterBase<GetConsultsStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new GetConsultsStateObject(request))
            {
                new Pipeline<GetConsultsStateObject>()
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.GetConsultsResponse;
            }
        }

    }
}
