﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.Processor;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.CancelAppointmentRequestMessage)]
    public class CancelAppointmentHandler : RequestResponseHandler
    {
        private CancelAppointmentRequestMessage _request;
        private string _serializedRequest;

        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                _request = (CancelAppointmentRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var processor = new CancelAppointmentProcessor();
                var response = (CancelAppointmentResponseMessage)processor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: GetConsults: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);

                return response;
            }
            catch(Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }


        private CancelAppointmentResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: Cancel Appointment Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new CancelAppointmentResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}
