﻿using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Mvi.PersonSearch.Messages;

namespace VA.TMP.Integration.VIMT.Mvi.Mappers
{
    /// <summary>
    /// Class to map data from Person Search to Attended Search request.
    /// </summary>
    public class PersonSearchMapper
    {
        private readonly PersonSearchStateObject _state;

        /// <summary>
        /// Default constructor.
        /// </summary>
        /// <param name="state">State.</param>
        public PersonSearchMapper(PersonSearchStateObject state)
        {
            _state = state;
        }

        /// <summary>
        /// Map data from Person Search to Attended Search request.
        /// </summary>
        /// <returns>AttendedSearchRequest</returns>
        public AttendedSearchRequest Map()
        {
            return new AttendedSearchRequest
            {
                BirthDate = _state.BirthDate,
                FamilyName = _state.FamilyName,
                FirstName = _state.FirstName,
                IsAttended = _state.IsAttended,
                MiddleName = _state.MiddleName,
                Edipi = _state.Edipi,
                FetchMessageProcessType = _state.FetchMessageProcessType,
                OrganizationName = _state.OrganizationName,
                PhoneNumber = _state.PhoneNumber,
                SocialSecurityNumber = _state.Ss,
                UserFirstName = _state.UserFirstName,
                UserLastName = _state.UserLastName,
                UserId = _state.UserId,
                SearchUse = _state.SearchUse
            };
        }
    }
}