﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.CancelAppointmentResponseMessage)]
    [DataContract]
    public class CancelAppointmentResponseMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets whether an exception occured.
        /// </summary>
        [DataMember]
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or sets the exception message.
        /// </summary>
        [DataMember]
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Gets or sets the Serialized instance.
        /// </summary>
        [DataMember]
        public string SerializedInstance { get; set; }

        /// <summary>
        /// Gets or sets the VIMT request.
        /// </summary>
        [DataMember]
        public string VimtRequest { get; set; }

        /// <summary>
        /// Gets or sets the VIMT response.
        /// </summary>
        [DataMember]
        public string VimtResponse { get; set; }

        //TO DO - get EC response object to pass back into the plugin - add this as an attribute of the response message
    }
}
