﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;
using System.Collections.Generic;

namespace VA.TMP.Integration.VIMT.Messages.VideoVisit
{
    /// <summary>
    /// VIMT message for VideoVisitCreateRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VideoVisitCreateRequestMessage)]
    [DataContract]
    public class VideoVisitCreateRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log requests.
        /// </summary>
        [DataMember]
        public bool LogRequest { get; set; }

        /// <summary>
        /// Gets or sets the Service Appointment Id.
        /// </summary>
        [DataMember]
        public Guid AppointmentId { get; set; }

        /// <summary>
        /// List of patients being booked
        /// </summary>
        [DataMember]
        public List<Guid> AddedPatients { get; set; }
    }
}