﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Mvi
{
    /// <summary>
    /// VIMT message for ProxyAddRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.ProxyAddRequestMessage)]
    [DataContract]
    public class ProxyAddRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets User's first name
        /// </summary>
        [DataMember]
        public string UserFirstName { get; set; }

        /// <summary>
        /// Gets or sets User's last name
        /// </summary>
        [DataMember]
        public string UserLastName { get; set; }

        /// <summary>
        /// Gets or sets whether to use a fake response.
        /// </summary>
        [DataMember]
        public string FakeResponseType { get; set; }

        /// <summary>
        /// Gets or sets whether to log requests.
        /// </summary>
        [DataMember]
        public bool LogRequest { get; set; }

        /// <summary>
        /// Gets or set the Service Appointment Id.
        /// </summary>
        [DataMember]
        public Guid? ServiceAppointmentId { get; set; }

        /// <summary>
        /// Gets or set the AppointmentId
        /// </summary>
        [DataMember]
        public Guid? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets ProcessingCode.
        /// </summary>
        [DataMember]
        public string ProcessingCode { get; set; }

        /// <summary>
        /// Gets or sets ReturnMviMessagesInResponse.
        /// </summary>
        [DataMember]
        public bool ReturnMviMessagesInResponse { get; set; }

        /// <summary>
        /// Gets or sets PatientVeteran.
        /// </summary>
        [DataMember]
        public bool PatientVeteran { get; set; }

        /// <summary>
        /// Gets or sets PatientServiceConnected.
        /// </summary>
        [DataMember]
        public bool PatientServiceConnected { get; set; }

        /// <summary>
        /// Gets or sets PatientType.
        /// </summary>
        [DataMember]
        public int PatientType { get; set; }
    }
}