﻿using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.CRM;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;
using VA.TMP.Integration.Plugins.Messages;
using VA.TMP.Integration.Plugins.Shared;
using VRMRest;
using Microsoft.Xrm.Sdk.Query;
using MCSShared;

namespace VA.TMP.Integration.Plugins.VistaIntegrationResult
{
    public class VistaIntegrationResultUpdatePostStageRunner : PluginRunner
    {
        public VistaIntegrationResultUpdatePostStageRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }

        private string VimtUrl;
        private Guid ContactId;

        public override string McsSettingsDebugField
        {
            get
            {
                return "cvt_vistaintegrationresult";
            }
        }

        public override void Execute()
        {
            //get VIR, get cancel reason, build VIMT Delete Request, send request to VIMT, process response
            //var vir = PrimaryEntity.ToEntity<cvt_vistaintegrationresult>();
            //var reason = vir.cvt_CancelReason?.Value;
            //var callVVS = false;

            //if (reason != null)
            //{
            //    var apptId = vir.cvt_Appointment != null ? vir.cvt_Appointment.Id : vir.cvt_ServiceActivity.Id;
            //    //send message to VIMT
            //    var contactId = Guid.Empty;
            //    using (var srv = new Xrm(OrganizationService))
            //    {

            //        var icnObj = srv.mcs_personidentifiersSet.FirstOrDefault(pi => pi.mcs_identifier == vir.cvt_PersonId);
            //        ContactId = icnObj.mcs_patient.Id;

            //        var vimtUrlObj = srv.mcs_integrationsettingSet.FirstOrDefault(x => x.mcs_name == "VIMT URL");
            //        if (vimtUrlObj == null) throw new InvalidPluginExecutionException("VIMT Url cannot be null, please ensure there is a setting called \"VIMT URL\"");

            //        VimtUrl = vimtUrlObj.mcs_value;

            //        var appt = srv.AppointmentSet.FirstOrDefault(a => a.Id == apptId);
            //        var sa = srv.ServiceAppointmentSet.FirstOrDefault(s => s.Id == appt.cvt_serviceactivityid.Id);
            //        callVVS = VistaPluginHelpers.RunVVS(sa, srv, Logger);
            //    }
            //    if (callVVS)
            //    {
            //        var response = SendCancelToVista(apptId);
            //        ProcessCancelResponse(response, apptId);
            //    }
            //}

        }

        private VideoVisitDeleteResponseMessage SendCancelToVista(Guid apptId)
        {
            var cancelRequest = new VideoVisitDeleteRequestMessage
            {
                AppointmentId = apptId,
                OrganizationName = PluginExecutionContext.OrganizationName,
                UserId = PluginExecutionContext.UserId,
                LogRequest = true,
                CanceledPatients = new List<Guid> { ContactId },
                WholeAppointmentCanceled = false
            };

            var vimtRequest = IntegrationPluginHelpers.SerializeInstance(cancelRequest);

            try
            {
                Logger.WriteDebugMessage("Sending Delete VVS to VIMT");
                var response = Utility.SendReceive<VideoVisitDeleteResponseMessage>(new Uri(VimtUrl), MessageRegistry.VideoVisitDeleteRequestMessage, cancelRequest, null);
                Logger.WriteDebugMessage("VVS Delete Successfully sent to VIMT");
                return response;
            } 
            catch (Exception ex)
            {
                var errorMessage = string.Format(IntegrationPluginHelpers.VimtServerDown, ex);
                IntegrationPluginHelpers.CreateAppointmentIntegrationResultOnVimtFailure("Create Video Visit", errorMessage, vimtRequest, typeof(VideoVisitDeleteRequestMessage).FullName, typeof(VideoVisitDeleteResponseMessage).FullName, MessageRegistry.VideoVisitDeleteRequestMessage, apptId, OrganizationService);

                Logger.WriteToFile(errorMessage);
                return null;
            }
        }

        private void ProcessCancelResponse(VideoVisitDeleteResponseMessage response, Guid apptId)
        {
            if (response == null) return;

            var errorMessage = response.ExceptionOccured ? response.ExceptionMessage : string.Empty;

            var integrationResultId = IntegrationPluginHelpers.CreateAppointmentIntegrationResult("Vista Cancel Patient", response.ExceptionOccured, errorMessage, response.VimtRequest, response.SerializedInstance, response.VimtResponse, typeof(VideoVisitDeleteRequestMessage).FullName, typeof(VideoVisitDeleteResponseMessage).FullName, MessageRegistry.VideoVisitDeleteRequestMessage, apptId, OrganizationService);

            if (!response.ExceptionOccured)
            {
                var status = IntegrationPluginHelpers.WriteVistaResults(response.WriteResults, integrationResultId, apptId, Guid.Empty, "book", OrganizationService, Logger);
                Logger.WriteDebugMessage("Vista Results Updated Successfully");
                if (status == (int)Appointmentcvt_IntegrationBookingStatus.CancelFailure)
                    Logger.WriteToFile("Failed to Cancel some/all Vista Appointments for patient: " + ContactId);
                else
                {
                    var updateAppt = new DataModel.Appointment
                    {
                        Id = apptId,
                        OptionalAttendees = GetNewAPList(apptId)
                    };
                    try
                    {
                        OrganizationService.Update(updateAppt);
                        Logger.WriteDebugMessage("Removed Patient From Appointment: " + ContactId);
                    }
                    catch(Exception ex)
                    {
                        Logger.WriteDebugMessage("Unable to Remove Activity Party from appointment following successful VistA Cancel.  Error: " + CvtHelper.BuildExceptionMessage(ex));
                    }
                }
            }
            else
                Logger.WriteToFile("Cancel Individual Patient Failed: " + errorMessage);
        }

        private List<ActivityParty> GetNewAPList(Guid apptId)
        {
            var newAPList = new List<ActivityParty>();
            var appt = OrganizationService.Retrieve(DataModel.Appointment.EntityLogicalName, apptId, new ColumnSet("optionalattendees")).ToEntity<DataModel.Appointment>();
            if (appt == null)
                throw new InvalidPluginExecutionException(string.Format("Appointment with id: {0} could not be found", apptId));
            foreach (var ap in appt.OptionalAttendees)
            {
                if (ap.PartyId.Id != ContactId)
                    newAPList.Add(ap);
            }
            return newAPList;
        }
    }
}
