﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VA.TMP.Integration.Plugins.Messages
{
    public class WriteResults
    {
        public WriteResult[] WriteResult { get; set; }
    }

    public class WriteResult
    {
        public string PersonId { get; set; }

        public PersonName Name { get; set; }

        public string FacilityCode { get; set; }

        public string FacilityName { get; set; }

        public string ClinicIen { get; set; }

        public string ClinicName { get; set; }

        public string DateTime { get; set; }

        public VistaStatus VistaStatus { get; set; }

        public string Reason { get; set; }
    }

    public enum VistaStatus
    {
        BOOKED,
        FAILED_TO_BOOK,
        FAILED_TO_CANCEL,
        CANCELLED
    }

    public class PersonName
    {
        public string FirstName { get; set; }

        public string LastName { get; set; }

        public string MiddleInitial { get; set; }

        public override string ToString() { return string.Format("{0}, {1} {2}".Trim(), LastName, FirstName, MiddleInitial); }
    }
}
