﻿using System;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VIMT.VideoVisit.Messages;

namespace VA.TMP.Integration.VIMT.Shared
{
    public static class VistaSchedulingUtilities
    {
        public static WriteResults MapEcToWriteResult(VIMTTmpWriteResults source)
        {
            var results = new List<WriteResult>();
            foreach (var res in source.VIMTTmpWriteResult)
            {
                var mappedresult = new WriteResult
                {
                    ClinicIen = res.ClinicIen,
                    ClinicName = res.ClinicName,
                    DateTime = res.DateTime.ToString("MM/dd/yyyy HH:mm 'GMT'"),
                    FacilityCode = res.FacilityCode,
                    FacilityName = res.FacilityName,
                    Name = res.Name == null ? new PersonName() : new PersonName
                    {
                        FirstName = res.Name.FirstName,
                        LastName = res.Name.LastName,
                        MiddleInitial = res.Name.MiddleInitial
                    },
                    PersonId = res.PersonId,
                    Reason = res.Reason,
                    VistaStatus = (VistaStatus)(int)res.VistaStatus
                };
                results.Add(mappedresult);
            }

            return new WriteResults
            {
                WriteResult = results.ToArray()
            };
        }

        public static VIMTTmpWriteResults CreateFakeBookResult(string fakeType, VideoVisitUpdateStateObject state)
        {
            return CreateFakeBookResult(fakeType, state.Appointment.AppointmentKind, state.Appointment.Patients, state.Appointment.Providers);
        }

        public static VIMTTmpWriteResults CreateFakeBookResult(string fakeType, VideoVisitCreateStateObject state)
        {
            return CreateFakeBookResult(fakeType, state.Appointment.AppointmentKind, state.Appointment.Patients, state.Appointment.Providers);
        }

        public static VIMTTmpWriteResults CreateFakeBookResult(string fakeType, VIMTTmpAppointmentKind appointmentKind, VIMTTmpPatients[] patients, VIMTTmpProviders[] providers)
        {
            var lastPat = patients[patients.Length - 1];
            var writeResults = new VIMTTmpWriteResults {VIMTTmpWriteResult = new VIMTTmpWriteResult[] {}};
            writeResults.VIMTTmpWriteResult = appointmentKind == VIMTTmpAppointmentKind.CLINIC_BASED ? new VIMTTmpWriteResult[2] : new VIMTTmpWriteResult[1];
            if (appointmentKind != VIMTTmpAppointmentKind.STORE_FORWARD)
            {
                var lastProv = providers[providers.Length - 1];
                var res = new VIMTTmpWriteResult
                {
                    ClinicIen = lastProv.Location?.Clinic?.Ien,
                    ClinicName = lastProv.Location?.Clinic?.Name,
                    DateTime = DateTime.UtcNow,
                    FacilityCode = lastProv.Location?.Facility?.SiteCode,
                    FacilityName = lastProv.Location?.Facility?.Name,
                    Name = new VIMTTmpPersonName
                    {
                        FirstName = lastPat.Name.FirstName,
                        LastName = lastPat.Name.LastName,
                        MiddleInitial = lastPat.Name.MiddleInitial
                    },
                    PersonId = lastPat.Id.UniqueId,
                    Reason = (fakeType == "0" || fakeType == "1") ? string.Empty : "Failure Reason 2",
                    VistaStatus = (fakeType == "0" || fakeType == "1") ? VIMTTmpVistaStatus.BOOKED : VIMTTmpVistaStatus.FAILED_TO_BOOK
                };
                writeResults.VIMTTmpWriteResult[0] = res;
            }
            if (appointmentKind == VIMTTmpAppointmentKind.CLINIC_BASED || appointmentKind == VIMTTmpAppointmentKind.STORE_FORWARD)
            {
                var res = new VIMTTmpWriteResult
                {
                    ClinicIen = lastPat.Location?.Clinic?.Ien,
                    ClinicName = lastPat.Location?.Clinic?.Name,
                    DateTime = DateTime.Now,
                    FacilityCode = lastPat.Location?.Facility?.SiteCode,
                    FacilityName = lastPat.Location?.Facility?.Name,
                    Name = new VIMTTmpPersonName
                    {
                        FirstName = lastPat.Name.FirstName,
                        LastName = lastPat.Name.LastName,
                        MiddleInitial = lastPat.Name.MiddleInitial
                    },
                    PersonId = lastPat.Id.UniqueId,
                    Reason = fakeType == "0" ? "" : "Failure Reason 1",
                    VistaStatus = fakeType == "0" ? VIMTTmpVistaStatus.BOOKED : VIMTTmpVistaStatus.FAILED_TO_BOOK
                };
                if (appointmentKind == VIMTTmpAppointmentKind.CLINIC_BASED)
                    writeResults.VIMTTmpWriteResult[1] = res;
                else
                    writeResults.VIMTTmpWriteResult[0] = res;
            }
            return writeResults;
        }

        public static VIMTTmpWriteResults CreateFakeCancelResult(string fakeType, VideoVisitDeleteStateObject state)
        {
            var virsForAppt = new List<cvt_vistaintegrationresult>();
            var matchingVirs = new List<cvt_vistaintegrationresult>();
            var writeResults = new List<VIMTTmpWriteResult>();
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                virsForAppt.AddRange(state.CrmAppointment != null
                    ? srv.cvt_vistaintegrationresultSet.Where(x => x.cvt_Appointment.Id == state.CrmAppointment.Id)
                    : srv.cvt_vistaintegrationresultSet.Where(x => x.cvt_ServiceActivity.Id == state.ServiceAppointment.Id));

                foreach(var status in state.CancelAppointmentRequest.VIMTTmpCancelAppointmentRequestDataInfo.PatientBookingStatuses.PersonBookingStatus)
                {
                    var vistaIntegrationResult = virsForAppt.Where(x => x.cvt_PersonId == status.Id.UniqueId).ToList();
                    matchingVirs.AddRange(vistaIntegrationResult);
                }
            }

            foreach(var match in matchingVirs)
            {
                var res = new VIMTTmpWriteResult
                {
                    ClinicIen = match.cvt_ClinicIEN,
                    ClinicName = match.cvt_ClinicName,
                    DateTime = DateTime.Now,
                    FacilityCode = match.cvt_FacilityCode,
                    FacilityName = match.cvt_FacilityName,
                    Name = new VIMTTmpPersonName
                    {
                        FirstName = match.cvt_FirstName,
                        LastName = match.cvt_LastName
                    },
                    PersonId = match.cvt_PersonId,
                    Reason = fakeType == "0" ? string.Empty : "Failed to Cancel, Reason 1",
                    VistaStatus = fakeType == "0" ? VIMTTmpVistaStatus.CANCELLED : VIMTTmpVistaStatus.FAILED_TO_CANCEL
                };
                writeResults.Add(res);
            }
            return new VIMTTmpWriteResults
            {
                VIMTTmpWriteResult = writeResults.ToArray()
            };
        }
    }
}