using System.Security.Cryptography;
using System.Text;

namespace VA.TMP.Integration.VIMT.Shared
{
    /// <summary>
    /// Class to generate random numbers as strings.
    /// </summary>
    public static class RandomDigits
    {
        /// <summary>
        /// Gets a random number of specified length.
        /// </summary>
        /// <param name="numberOfDigits">The number of digits for the random number.</param>
        /// <returns>Random number string of specified length.</returns>
        public static string GetRandomDigitString(int numberOfDigits)
        {
            var sb = new StringBuilder();
            for (var i = 0; i < numberOfDigits; ++i) sb.Append((char)('0' + NextRandomDigit()));

            return sb.ToString();
        }

        /// <summary>
        /// Generates a random integer.
        /// </summary>
        /// <returns>Random integer.</returns>
        private static int NextRandomDigit()
        {
            var bytes = new byte[8];

            using (var provider = new RNGCryptoServiceProvider())
            {
                while (true)
                {
                    provider.GetBytes(bytes);

                    if (bytes[0] >= 250) continue;

                    return bytes[0] % 10;
                }
            }
        }
    }
}