﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using System;
using System.Linq;
using VA.TMP.DataModel;

namespace VA.TMP.CRM
{
    public class McsResourceCreateUpdatePreStageRunner : PluginRunner
    {
        public McsResourceCreateUpdatePreStageRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }
        #region Primary Functionality
        /// <summary>
        /// Execute method is the entry point into the runner class, and is what is called by the Actual Plugin: McsResourceCreateUpdatePreStage
        /// </summary>
        /// <remarks>
        /// The plugin checks that the resource record has the default cart type set if the cart is not selected by the user. 
        /// The component type allowed for the resource is filtered based on the cart type selected. 
        /// </remarks>
        public override void Execute()
        {
            if (PrimaryEntity.LogicalName != mcs_resource.EntityLogicalName && !PrimaryEntity.Attributes.Contains("cvt_systemtype"))
                return;

            mcs_resource resource = PrimaryEntity.ToEntity<mcs_resource>();
            using (var srv = new Xrm(OrganizationService))
            {
                //Set the default Cart Type for the resource when the Cart type is not available
                if (resource.cvt_systemtype != null && resource.cvt_systemtype.Value != 917290001)
                {
                    var cartType = srv.cvt_carttypeSet.FirstOrDefault(c => c.cvt_ResourceSystemType.Value == resource.cvt_systemtype.Value);

                    if (cartType == null)
                    {
                        Logger.WriteToFile("Default Cart Type not found for the Resource System Type" + resource.cvt_systemtype.Value);
                    }
                    else
                    {
                        PrimaryEntity.Attributes["cvt_carttypeid"] = new EntityReference(cvt_carttype.EntityLogicalName, cartType.cvt_carttypeId.Value);
                    }
                }
            }
        }
        #endregion

        #region AbstractClassRequiredMethods
        public override string McsSettingsDebugField
        {
            get { return "mcs_resourceplugin"; }
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.PostEntityImages["post"];
        }
        #endregion
    }
}