using System;
using System.ServiceModel;
using Microsoft.Xrm.Sdk;

namespace MCSUtilities2011
{
    [Serializable]
    public class MCSLogger
    {
        private int _sequence = 1;
        private ITracingService _tracingService;
        public ITracingService setTracingService
        {
            set { _tracingService = value; }
        }
        private IOrganizationService _service;
        public IOrganizationService setService
        {
            set { _service = value; }
        }
        private string _method;
        public string setMethod
        {
            get { return _method; }
            set { _method = value; }
        }

        private string _relatedEntityName;
        public string setEntityName
        {
            get { return _relatedEntityName; }
            set { _relatedEntityName = value; }
        }
        private Guid _relatedEntityId;
        public Guid setEntityId
        {
            get { return _relatedEntityId; }
            set { _relatedEntityId = value; }
        }
        private string _module;
        public string setModule
        {
            get { return _module; }
            set { _module = value; }
        }

        private bool _debug = true;
        public bool setDebug
        {
            set { _debug = value; }
        }
        private bool _txnTiming = true;
        public bool setTxnTiming
        {
            set { _txnTiming = value; }
        } private bool _granularTiming = true;
        public bool setGranularTiming
        {
            set { _granularTiming = value; }
        }
        private void writeOutMessage(string message, bool debugMessage, bool granularTiming, bool TxnTiming)
        {
            try
            {
                DateTime myNow = DateTime.Now;
                message = myNow.ToString("HH:mm:ss.fff") + " - " + message;               
                Entity logCreate = new Entity("mcs_log");
                logCreate["mcs_name"] = _module;
                //logCreate["new_timestamp"] = myNow.ToString("yyyy/MM/dd HH:mm:ss.fff");              
                logCreate["mcs_errormessage"] = message;
                logCreate["mcs_debugmessage"] = debugMessage;
                logCreate["mcs_grantiming"] = granularTiming;
                logCreate["mcs_txntiming"] = TxnTiming;
                //logCreate["mcs_entityid"] = (_relatedEntityId != Guid.Empty) ? _relatedEntityId.ToString() : String.Empty;
                //logCreate["mcs_entityname"] = _relatedEntityName;
                logCreate["mcs_method"] = _method;
                logCreate["mcs_sequence"] = _sequence;
                _sequence += 1;
                _tracingService.Trace(message);
                _service.Create(logCreate);
            }
            catch (FaultException<OrganizationServiceFault>)
            {
                throw new InvalidPluginExecutionException("Log failed to write");
            }
            catch (Exception)
            {
                throw new InvalidPluginExecutionException("Log failed to write");
            }
        }
        public void WriteToFile(string message)
        {
            writeOutMessage(message,false,false,false);
        }
        public void WriteTxnTimingMessage(string message)
        {
            if (_txnTiming)
            {
                writeOutMessage(message,false, false,true);
            }
        }
        public void WriteGranularTimingMessage(string message)
        {
            if (_granularTiming)
            {
                writeOutMessage(message,false,true,false);
            }
        }
        public void WriteDebugMessage(string message)
        {
            if (_debug)
            {
                writeOutMessage(message,true,false,false);
            }
        }
    }
}
