﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;

namespace MCSShared
{
    public static partial class CvtHelper
    {

        #region Email Related Functions
        //Overloaded method: creates a list from an Activty Party to populate a From, To, or CC field
        public static List<ActivityParty> SetPartyList(ActivityParty user)
        {
            List<ActivityParty> userList = new List<ActivityParty>();
            //user if exists
            if (user != null)
                userList.Add(user);
            return userList;
        }

        //Overloaded method: return empty list if userRef is null, otherwise get Activity party and call first SetEmailProperties method
        public static List<ActivityParty> SetPartyList(EntityReference userRef)
        {
            return userRef == null ? new List<ActivityParty>() :
                CvtHelper.SetPartyList(new ActivityParty() { PartyId = new EntityReference(userRef.LogicalName, userRef.Id) });
        }

        //Overloaded method: creates a list from an EntityCollection to populate a From, To, or CC field
        public static List<ActivityParty> SetPartyList(EntityCollection userCollection)
        {
            List<ActivityParty> userList = new List<ActivityParty>();

            foreach (var record in userCollection.Entities.Select(e => e).Distinct())
            {
                var activityParty = new ActivityParty() { PartyId = new EntityReference(record.LogicalName, record.Id) };
                userList.Add(activityParty);
            }
            return userList;
        }

        public static List<ActivityParty> SetPartyList(List<SystemUser> userList)
        {
            List<ActivityParty> users = new List<ActivityParty>();

            foreach (SystemUser u in userList.Select(e => e).Distinct())
            {
                var activityParty = new ActivityParty() { PartyId = new EntityReference(u.LogicalName, u.Id) };
                users.Add(activityParty);
            }
            return users;
        }

        //This method takes the email passed in and sends it
        public static void SendEmail(Email email, IOrganizationService OrganizationService)
        {
            SendEmailRequest requestObj = new SendEmailRequest()
            {
                EmailId = (Guid)email.ActivityId,
                IssueSend = true,
                TrackingToken = ""
            };
            SendEmailResponse response = (SendEmailResponse)OrganizationService.Execute(requestObj);
        }

        //Saves and Sends the email
        public static void UpdateSendEmail(Email email, IOrganizationService OrganizationService)
        {
            OrganizationService.Update(email);
            SendEmail(email, OrganizationService);
        }

        public static string EmailFooter()
        {
            return "<br/><br/>Please Do Not Reply to this message.  It comes from an unmonitored mailbox.  For any questions or concerns, please contact your VA Facility or VA Clinical Team.";
        }
        #endregion

    }
}