﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.Processor
{
    /// <summary>
    /// Video Visit Processor for VIMT.
    /// </summary>
    public class VideoVisitCreateProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">VideoVisitCreateRequestMessage.</param>
        /// <returns>VideoVisitCreateResponseMessage.</returns>
        public IMessageBase Execute(VideoVisitCreateRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, GetServiceAppointmentStep>("GetServiceAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, MapAppointmentStep>("MapAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, SerializeAppointmentStep>("SerializeAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, PostToVideoVisitServiceStep>("PostToVideoVisitServiceStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitCreateStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new VideoVisitCreateStateObject(request))
            {
                new Pipeline<VideoVisitCreateStateObject>()
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("GetServiceAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("MapAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("SerializeAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("PostToVideoVisitServiceStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitCreateStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.VideoVisitCreateResponseMessage;
            }
        }
    }
}