﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.Processor
{
    /// <summary>
    /// Proxy Add Processor for VIMT.
    /// </summary>
    public class ProxyAddProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">ProxyAddRequestMessage.</param>
        /// <returns>ProxyAddResponseMessage.</returns>
        public IMessageBase Execute(ProxyAddRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<ProxyAddStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, GetServiceAppointmentStep>("GetServiceAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, GetVeteranStep>("GetVeteranStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, GetVeteranIdentifiersStep>("GetVeteranIdentifiersStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, CreatePatientVeteranIdentifierStep>("CreatePatientVeteranIdentifierStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, MapPatientVeteranIdentifierToProxyAddRequestEcStep>("MapPatientVeteranIdentifierToProxyAddRequestEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, SendPatientVeteranIdentifierToEcStep>("SendPatientVeteranIdentifierToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, CreateProviderVeteranIdentifierStep>("CreateProviderVeteranIdentifierStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, MapProviderVeteranIdentifierToProxyAddRequestEcStep>("MapProviderVeteranIdentifierToProxyAddRequestEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, SendProviderVeteranIdentifierToEcStep>("SendProviderVeteranIdentifierToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<ProxyAddStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new ProxyAddStateObject(request))
            {
                new Pipeline<ProxyAddStateObject>()
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("GetServiceAppointmentStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("GetVeteranStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("GetVeteranIdentifiersStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("CreatePatientVeteranIdentifierStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("MapPatientVeteranIdentifierToProxyAddRequestEcStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("SendPatientVeteranIdentifierToEcStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("CreateProviderVeteranIdentifierStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("MapProviderVeteranIdentifierToProxyAddRequestEcStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("SendProviderVeteranIdentifierToEcStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<ProxyAddStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.ProxyAddResponseMessage;
            }
        }
    }
}