﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.PipelineSteps.PersonSearch;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.Processor
{
    /// <summary>
    /// Person Search Processor for VIMT.
    /// </summary>
    public class PersonSearchProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">PersonSearchRequestMessage.</param>
        /// <returns>PersonSearchRequestMessage.</returns>
        public IMessageBase Execute(PersonSearchRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<PersonSearchStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<PersonSearchStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<PersonSearchStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<PersonSearchStateObject>, MapPersonSearchToAttendedSearchStep>("MapPersonSearchToAttendedSearchStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<PersonSearchStateObject>, SendPersonSearchToEcStep>("SendPersonSearchToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<PersonSearchStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new PersonSearchStateObject(request))
            {
                new Pipeline<PersonSearchStateObject>()
                    .Register(container.Resolve<FilterBase<PersonSearchStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<PersonSearchStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<PersonSearchStateObject>>("MapPersonSearchToAttendedSearchStep"))
                    .Register(container.Resolve<FilterBase<PersonSearchStateObject>>("SendPersonSearchToEcStep"))
                    .Register(container.Resolve<FilterBase<PersonSearchStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<PersonSearchStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.PersonSearchResponseMessage;
            }
        }
    }
}