﻿using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom
{
    /// <summary>
    /// VIMT message for VirtualMeetingRoomCreateResponseMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VirtualMeetingRoomCreateResponseMessage)]
    [DataContract]
    public class VirtualMeetingRoomCreateResponseMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets whether an exception occured.
        /// </summary>
        [DataMember]
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or sets the exception message.
        /// </summary>
        [DataMember]
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Gets or sets the Meeting Room Name.
        /// </summary>
        [DataMember]
        public string MeetingRoomName { get; set; }

        /// <summary>
        /// Gets or sets the Patient URL.
        /// </summary>
        [DataMember]
        public string PatientUrl { get; set; }

        /// <summary>
        /// Gets or sets the Provider URL.
        /// </summary>
        [DataMember]
        public string ProviderUrl { get; set; }

        /// <summary>
        /// Gets or sets the Patient PIN.
        /// </summary>
        [DataMember]
        public string PatientPin { get; set; }

        /// <summary>
        /// Gets or sets the Provider PIN.
        /// </summary>
        [DataMember]
        public string ProviderPin { get; set; }

        /// <summary>
        /// Gets or sets the CorrelationId.
        /// </summary>
        [DataMember]
        public string AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the Dialing Alias.
        /// </summary>
        [DataMember]
        public string DialingAlias { get; set; }

        /// <summary>
        /// Gets or sets the Misc data.
        /// </summary>
        [DataMember]
        public string MiscData { get; set; }

        /// <summary>
        /// Gets or sets the Serialized instance.
        /// </summary>
        [DataMember]
        public string SerializedInstance { get; set; }

        /// <summary>
        /// Gets or sets the VIMT request.
        /// </summary>
        [DataMember]
        public string VimtRequest { get; set; }

        /// <summary>
        /// Gets or sets the VIMT response.
        /// </summary>
        [DataMember]
        public string VimtResponse { get; set; }
    }
}