﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.VideoVisit
{
    /// <summary>
    /// VIMT message for VideoVisitDeleteRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VideoVisitDeleteRequestMessage)]
    [DataContract]
    public class VideoVisitDeleteRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log requests.
        /// </summary>
        [DataMember]
        public bool LogRequest { get; set; }

        /// <summary>
        /// Gets or sets the Service Appointment Id.
        /// </summary>
        [DataMember]
        public Guid AppointmentId { get; set; }
    }
}