﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Mvi
{
    /// <summary>
    /// VIMT message for PersonSearchRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.PersonSearchRequestMessage)]
    [DataContract]
    public class PersonSearchRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log requests.
        /// </summary>
        [DataMember]
        public bool LogRequest { get; set; }

        /// <summary>
        /// Gets or sets birth date.
        /// </summary>
        [DataMember]
        public string BirthDate { get; set; }

        /// <summary>
        /// Gets or sets last name.
        /// </summary>
        [DataMember]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets first name.
        /// </summary>
        [DataMember]
        public string FirstName { get; set; }

        /// <summary>
        /// Gets or sets Fetch Message Process Type.
        /// </summary>
        [DataMember]
        public MessageProcessType FetchMessageProcessType { get; set; }

        /// <summary>
        /// Gets or sets whether attended search.
        /// </summary>
        [DataMember]
        public bool IsAttended { get; set; }

        /// <summary>
        /// Gets or sets social security number.
        /// </summary>
        [DataMember]
        public string Ss { get; set; }

        /// <summary>
        /// Gets or sets user first name.
        /// </summary>
        [DataMember]
        public string UserFirstName { get; set; }

        /// <summary>
        /// Gets or sets user last name.
        /// </summary>
        [DataMember]
        public string UserLastName { get; set; }

        /// <summary>
        /// Gets or sets middle name.
        /// </summary>
        [DataMember]
        public string MiddleName { get; set; }

        /// <summary>
        /// Gets or sets EDIPI.
        /// </summary>
        [DataMember]
        public string Edipi { get; set; }

        /// <summary>
        /// Gets or sets phone number.
        /// </summary>
        [DataMember]
        public string PhoneNumber { get; set; }

        /// <summary>
        /// Gets or sets Search Use.
        /// </summary>
        [DataMember]
        public string SearchUse { get; set; }

        /// <summary>
        /// Gets or sets Query.
        /// </summary>
        [DataMember]
        public string Query { get; set; }

        /// <summary>
        /// Gets or sets Person Search Fake Response Type.
        /// </summary>
        [DataMember]
        public string PersonSearchFakeResponseType { get; set; }
    }
}