﻿using System;

namespace VA.TMP.Integration.Plugins.Messages
{
    public class GetPersonIdentifiersRequestMessage
    {
        public string MessageId { get; set; }

        public string OrganizationName { get; set; }

        public Guid UserId { get; set; }

        public string UserFirstName { get; set; }

        public string UserLastName { get; set; }

        public bool LogRequest { get; set; }

        public string Alias { get; set; }

        public string PatientSearchIdentifier { get; set; }

        public string IdentifierClassCode { get; set; }

        public string IdentifierType { get; set; }

        public string AssigningFacility { get; set; }
     
        public string AssigningAuthority { get; set; }

        public override string ToString()
        {
            return string.Format("{0}^{1}^{2}^{3}", PatientSearchIdentifier,
                string.IsNullOrEmpty(IdentifierType) ? "NI" : IdentifierType,
                string.IsNullOrEmpty(AssigningFacility) ? "200DOD" : AssigningFacility,
                string.IsNullOrEmpty(AssigningAuthority) ? "USDOD" : AssigningAuthority);
        }
        
        public string FirstName { get; set; }

        public string MiddleName { get; set; }

        public string FamilyName { get; set; }

        public string FullAddress { get; set; }

        public string FullName { get; set; }

        public string DateofBirth { get; set; }

        public string DateofDeath { get; set; }

        public string RawValueFromMvi { get; set; }

        public MessageProcessType FetchMessageProcessType { get; set; }

        public string RecordSource { get; set; }

        public string Ss { get; set; }

        public string Edipi { get; set; }

        public string PhoneNumber { get; set; }

        public string Gender { get; set; }

        public string IdTheftIndicator { get; set; }

        public string ServerName { get; set; }

        public string SelectedPersonFakeResponseType { get; set; }
        
        public UnattendedSearchRequest[] CorrespondingIds { get; set; } 
    }
}