﻿using BaseVimtConsoleTester.Messages;
using System;
using System.IO;
using System.Text;
using System.Xml.Serialization;
using VRMRest;

namespace BaseVimtConsoleTester
{
    public class Program
    {
        private static void Main()
        {
            try
            {
                //InvokeVimtDynamically();
                //TestVirtualMeetingRoom();
                //TestVideoVisit();
                //TestPersonSearch();
                TestProxyAdd();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
            finally
            {
                Console.WriteLine("Press [Enter] key to end.");
                Console.ReadLine();
            }
        }

        private static void InvokeVimtDynamically()
        {
            var request = new VirtualMeetingRoomCreateRequestMessage
            {
                LogRequest = false,
                UserId = new Guid("01C13CE7-8FA8-E411-ACDB-00155D5575E0"),
                OrganizationName = "CVT-DEV2015",
                AppointmentId = new Guid("73999643-E612-E611-80CE-000D3A00D568"),
                PatientId = Guid.NewGuid(),
                ProviderId = Guid.NewGuid(),
                MiscData = string.Empty
            };

            var serializedRequest = SerializeInstance(request);
            var requestType = Type.GetType("BaseVimtConsoleTester.Messages.VirtualMeetingRoomCreateRequestMessage");
            var responseType = Type.GetType("BaseVimtConsoleTester.Messages.VirtualMeetingRoomCreateResponseMessage");

            var response = InvokeVimtDynamically2(requestType, responseType, serializedRequest, MessageRegistry.VirtualMeetingRoomCreateRequestMessage, "http://localhost:8085");
        }

        private static object InvokeVimtDynamically2(Type requestType, Type responseType, string serializedRequest, string registryMessage, string vimtBaseUri)
        {
            var serializer = new XmlSerializer(requestType);

            using (TextReader reader = new StringReader(serializedRequest))
            {
                var result = serializer.Deserialize(reader);
                var method = typeof(Utility).GetMethod("SendReceive");
                var generic = method.MakeGenericMethod(responseType);
                var response = generic.Invoke(null, new[] { new Uri(vimtBaseUri), registryMessage, result, null });

                var responseInstance = response;
                if (responseInstance == null) throw new Exception("The response value was not of the proper type");

                return responseInstance;
            }
        }

        private static void TestVideoVisit()
        {
            var appointmentId = new Guid("242dbbec-0422-e611-80d3-000d3a00d568");

            var request = new VideoVisitCreateRequestMessage { LogRequest = true, UserId = Guid.NewGuid(), OrganizationName = "CVT-DEV2015", AppointmentId = appointmentId };
            var response = Utility.SendReceive<VideoVisitCreateResponseMessage>(new Uri("http://localhost:8085"), MessageRegistry.VideoVisitCreateRequestMessage, request, null);

            Console.WriteLine(SerializeInstance(response));
            Console.WriteLine(Environment.NewLine);

            var request2 = new VideoVisitDeleteRequestMessage { LogRequest = true, UserId = Guid.NewGuid(), OrganizationName = "CVT-DEV2015", AppointmentId = appointmentId };
            var response2 = Utility.SendReceive<VideoVisitDeleteResponseMessage>(new Uri("http://localhost:8085"), MessageRegistry.VideoVisitDeleteRequestMessage, request2, null);

            Console.WriteLine(SerializeInstance(response2));
            Console.WriteLine(Environment.NewLine);
        }

        private static void TestVirtualMeetingRoom()
        {
            var request = new VirtualMeetingRoomCreateRequestMessage
            {
                LogRequest = false,
                UserId = new Guid("01C13CE7-8FA8-E411-ACDB-00155D5575E0"),
                OrganizationName = "CVT-DEV2015",
                AppointmentId = new Guid("73999643-E612-E611-80CE-000D3A00D568"),
                PatientId = Guid.NewGuid(),
                ProviderId = Guid.NewGuid(),
                MiscData = string.Empty
            };

            Console.WriteLine(SerializeInstance(request));
            Console.WriteLine(Environment.NewLine);

            var response = Utility.SendReceive<VirtualMeetingRoomCreateResponseMessage>(new Uri("http://localhost:8085"), MessageRegistry.VirtualMeetingRoomCreateRequestMessage, request, null);

            Console.WriteLine(SerializeInstance(response));
            Console.WriteLine(Environment.NewLine);

            var request2 = new VirtualMeetingRoomDeleteRequestMessage
            {
                LogRequest = true,
                UserId = Guid.NewGuid(),
                OrganizationName = "CVT-DEV2015",
                AppointmentId = new Guid(response.AppointmentId),
                MiscData = string.Empty
            };

            Console.WriteLine(SerializeInstance(request2));
            Console.WriteLine(Environment.NewLine);

            var response2 = Utility.SendReceive<VirtualMeetingRoomDeleteResponseMessage>(new Uri("http://localhost:8085"), MessageRegistry.VirtualMeetingRoomDeleteRequestMessage, request2, null);

            Console.WriteLine(SerializeInstance(response2));
            Console.WriteLine(Environment.NewLine);
        }

        private static void TestPersonSearch()
        {
            var request = new PersonSearchRequestMessage { LogRequest  = true, UserId = Guid.NewGuid(), OrganizationName = "CVT-DEV2015" };
            var response = Utility.SendReceive<PersonSearchResponseMessage>(new Uri("http://localhost:8085"), MessageRegistry.PersonSearchRequestMessage, request, null);

            Console.WriteLine(SerializeInstance(response));
            Console.WriteLine(Environment.NewLine);
        }
        //A92A2232-6371-E611-80DB-000D3A007BF6
        private static void TestProxyAdd()
        {
            var request = new ProxyAddRequestMessage { LogRequest = true, UserId = Guid.NewGuid(), OrganizationName = "CVT-DEV2015",
                                                       ServiceAppointmentId = new Guid("A92A2232-6371-E611-80DB-000D3A007BF6"),
                                                       UserFirstName = "Joseph",
                                                       UserLastName = "Duty",
                                                       FakeResponseType = "0"
            };
            var response = Utility.SendReceive<ProxyAddResponseMessage>(new Uri("http://localhost:8085"), MessageRegistry.ProxyAddRequestMessage, request, null);

            Console.WriteLine(SerializeInstance(response));
            Console.WriteLine(Environment.NewLine);
        }

        private static string SerializeInstance<T>(T classInstance)
        {
            using (var stream = new MemoryStream())
            {
                var serializer = new XmlSerializer(typeof(T));

                serializer.Serialize(stream, classInstance);
                return Encoding.ASCII.GetString(stream.ToArray());
            }
        }
    }
}