﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;

namespace VA.TMP.CRM
{
    public class ServiceAppointmentSetStatePostStageRunner : PluginRunner
    {
        #region Constructor
        public ServiceAppointmentSetStatePostStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        #region Internal Methods/Properties
        public override void Execute()
        {           
            CheckStatusDate(PluginExecutionContext.PrimaryEntityId);           
        }

        /// <summary>
        /// Checking Service Appointment Status & DateTime.
        /// </summary>
        /// <param name="serviceApptId"></param>
        /// <param name="Logger"></param>
        /// <param name="OrganizationService"></param>
        internal void CheckStatusDate(Guid serviceApptId)
        {
            Logger.setMethod = "CheckStatusDate";
            Logger.WriteDebugMessage("Starting CheckStatusDate");
            
                //Retrieve the Service Appointment
                ServiceAppointment serviceAppt = OrganizationService.Retrieve("serviceappointment", serviceApptId,
                    new ColumnSet(true)).ToEntity<ServiceAppointment>();
                //Check for Complete or Patient No Show status. 
            if (serviceAppt.StatusCode.Value == (int) serviceappointment_statuscode.Completed ||
                serviceAppt.StatusCode.Value == (int) serviceappointment_statuscode.PatientNoShow)
            {
                var scheduledStart = serviceAppt.ScheduledStart?.ToLocalTime();
                int? dateComparison = scheduledStart?.CompareTo(DateTime.Now.ToLocalTime());
                if (dateComparison > 0)
                    throw new InvalidPluginExecutionException(
                        "customA Service Appointment scheduled in the future cannot be closed in a 'Complete' or 'Patient No Show' status. The closure of this Service Appointment has been aborted.");
            }
            else
            {
                return;
            }

            Logger.WriteDebugMessage("Ending CheckStatusDate");
        }       
        #endregion

        #region Additional Interface Methods
        public override string McsSettingsDebugField
        {
            get { return "cvt_serviceactivityplugin"; }
        }
        #endregion
    }
}