﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using System;
using System.Linq;
using VA.TMP.DataModel;

namespace VA.TMP.CRM
{
    public class McsSiteUpdatePostStageRunner : PluginRunner
    {
        #region Constructor
        public McsSiteUpdatePostStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        #region Internal Methods/Properties
        public override void Execute()
        {
            if (PluginExecutionContext.Depth > 1) { return; }
            Entity siteContext = PrimaryEntity.ToEntity<mcs_site>();
            using (var srv = new Xrm(OrganizationService))
            {
                var thisSite = srv.mcs_siteSet.FirstOrDefault(i => i.Id == PluginExecutionContext.PrimaryEntityId);
                if (thisSite == null)                         
                    return;

                //Limit calling Update System Site function to change in name, timezone 
                if ((siteContext.Contains("mcs_name")) || (siteContext.Contains("mcs_timezone")))
                    UpdateSystemSite(McsHelper.getEntRefID("mcs_relatedactualsiteid"));
                else
                    Logger.WriteDebugMessage("No need to update System Site record");
                        
                //Limit calling Align Locations to change in Facility
                if (siteContext.Contains("mcs_facilityid"))
                {
                    CvtHelper.AlignLocations(thisSite, OrganizationService, Logger);
                    Logger.WriteDebugMessage("Checking if Site Team needs to be updated.");
                    UpdateSiteTeam(thisSite.Id);
                }
                else
                    Logger.WriteDebugMessage("No need to Align Locations");
            }
        }

        internal void UpdateSystemSite(Guid id)
        {
            using (var srv = new Xrm(OrganizationService))
            {
                Logger.setMethod = "UpdateSystemSite";
                Logger.WriteTxnTimingMessage("starting UpdateSystemSite");
                var systemSite = srv.SiteSet.FirstOrDefault(i => i.Id == id);
                if (systemSite == null) return;
                Logger.WriteTxnTimingMessage("Retrieved system site");

                var updateSystemSite = new Site
                {
                    Id = systemSite.Id,
                    Name = McsHelper.getStringValue("mcs_name"),
                    TimeZoneCode = McsHelper.getIntValue("mcs_timezone"),
                };

                OrganizationService.Update(updateSystemSite);
                Logger.WriteDebugMessage("System Site record updated");
            }
        }

        internal void UpdateSiteTeam(Guid id)
        {
            Logger.setMethod = "UpdateSiteTeam";
            Logger.WriteDebugMessage("starting UpdateSiteTeam");
            using (var srv = new Xrm(OrganizationService))
            {
                var tssSite = srv.mcs_siteSet.FirstOrDefault(s => s.Id == id);

                if (tssSite != null)
                {
                    var siteTeam = srv.TeamSet.FirstOrDefault(t => t.Name == tssSite.mcs_name);
                    if (siteTeam == null)
                        return;

                    //Check for BU
                    if (siteTeam.BusinessUnitId.Id != tssSite.mcs_BusinessUnitId.Id)
                    {
                        CvtHelper.UpdateSiteTeam(siteTeam.Id, tssSite.mcs_BusinessUnitId.Id, Logger, OrganizationService);
                    }
                }
            }
        }
        #endregion

        #region Additional Interface Methods/Properties
        public override string McsSettingsDebugField
        {
            get { return "mcs_siteplugin"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.PostEntityImages["post"];
        }
        #endregion
    }
}