﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Linq;
using System.ServiceModel;
using VA.TMP.DataModel;

namespace VA.TMP.CRM
{
    public class McsResourceGroupUpdatePostStageRunner : PluginRunner
    {
        #region Constructor
        public McsResourceGroupUpdatePostStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        #region Internal Methods/Properties
        public override void Execute()
        {
            if (PluginExecutionContext.Depth > 1)
                return;

            //Check Update Boolean field to see if flagged for Update. Only on the first change (since checking context)
            var thisResourceGroup = PrimaryEntity.ToEntity<mcs_resourcegroup>();

            if (thisResourceGroup.Attributes.Contains("mcs_name"))
            {
                var thisGroup = OrganizationService.Retrieve(mcs_resourcegroup.EntityLogicalName, thisResourceGroup.Id, new ColumnSet(true)).ToEntity<mcs_resourcegroup>();
                var OOBResourceGroup = new ConstraintBasedGroup()
                {
                    Id = thisGroup.mcs_RelatedResourceGroupId.Id,
                    Name = thisResourceGroup.mcs_name
                };
                OrganizationService.Update(OOBResourceGroup);
            }
        }
        #endregion

        #region Additional Interface Methods/Properties
        public override string McsSettingsDebugField
        {
            get { return "mcs_resourcegroupplugin"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.PostEntityImages["post"];
        }
        #endregion
    }
}


//public static string AddResourceToConstraintGroup(string resourceId)
//        {
//            var builder = "resource[\"Id\"] == ";
//            builder += new Guid(resourceId).ToString("B");
//            builder += " || ";
//            return builder;
//        }

//        /// <summary>
//        /// wraps the xml body string with the appropriate tags to make it a valid constraints field in a constraintbasedgroup record
//        /// </summary>
//        /// <param name="strBuilder">the string that becomes the body of the constraintbasedgroup</param>
//        /// <returns>the full Constraints xml string</returns>
//        public static StringBuilder BuildConstraintsXML(StringBuilder strBuilder)
//        {
//            var mainStrBuilder = new System.Text.StringBuilder("<Constraints><Constraint><Expression><Body>");
//            if (strBuilder.Length == 0)
//                strBuilder.Append("false || ");
//            mainStrBuilder.Append(strBuilder);
//            //Remove " || " from end and close the Constraint Group with the correct tags
//            mainStrBuilder.Remove(mainStrBuilder.Length - 4, 4);
//            mainStrBuilder.Append("</Body><Parameters><Parameter name=\"resource\" /></Parameters></Expression></Constraint></Constraints>");
//            return mainStrBuilder;
//        }