﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using System;
using System.Linq;
using System.ServiceModel;
using VA.TMP.DataModel;

namespace VA.TMP.CRM
{
    public class McsGroupResourceUpdatePostStageRunner : PluginRunner
    {
        #region Constructor
        public McsGroupResourceUpdatePostStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }       
        #endregion
        
       
        public override void Execute()
        {
            UpdateResourceGroup(PrimaryEntity.Id);
        }
        #region Logic
        internal void UpdateResourceGroup(Guid thisId) //Now Group Resource instead of Resource Group
        {
            Logger.setMethod = "UpdateResourceGroup";
            Logger.WriteDebugMessage("starting UpdateResourceGroup");
            using (var srv = new Xrm(OrganizationService))
            {
                try
                {
                    var thisGroupResource = srv.mcs_groupresourceSet.FirstOrDefault(g => g.Id == thisId);
                    if (thisGroupResource.mcs_relatedResourceGroupId == null)
                        return;

                    var RelatedResourceGroupId = thisGroupResource.mcs_relatedResourceGroupId.Id;
                    var resourceGroup = srv.mcs_resourcegroupSet.FirstOrDefault(i => i.Id == RelatedResourceGroupId);

                    if (resourceGroup == null) 
                        return;

                    Logger.WriteDebugMessage("mcs_resourcegroup was found");

                    var resourceNames = "";
                    var count = 0;
                    var builder = CvtHelper.GetResources(RelatedResourceGroupId, srv, out resourceNames, out count);
                    builder = CvtHelper.BuildConstraintsXML(builder);
                    Logger.WriteDebugMessage("Built XML");
                                      
                    if (resourceNames != resourceGroup.cvt_resources)
                    {
                        var resGroupUpdate = new mcs_resourcegroup
                        {
                            Id = resourceGroup.Id,
                            cvt_resources = resourceNames
                        };
                        OrganizationService.Update(resGroupUpdate);
                        Logger.WriteDebugMessage("Updated Resource Group with new string: " + resourceNames);

                        if (resourceGroup.mcs_RelatedResourceGroupId != null)
                        {
                            //Could check if builder = constraints to see if update even needs to happen
                            var group = new ConstraintBasedGroup
                            {
                                Id = resourceGroup.mcs_RelatedResourceGroupId.Id,
                                Constraints = builder.ToString()
                            };
                            OrganizationService.Update(group);
                            Logger.WriteDebugMessage("System Resource Updated with " + count + " resources");
                        }
                    }
                }
                catch (FaultException<OrganizationServiceFault> ex)
                {
                    Logger.WriteToFile(ex.Message);
                    throw new InvalidPluginExecutionException(ex.Message);
                }
                catch (Exception ex)
                {
                    Logger.WriteToFile(ex.Message);
                    throw new InvalidPluginExecutionException(ex.Message);
                }
            }
        }
 
    #endregion

        #region Additional Interface Methods
        public override string McsSettingsDebugField
        {
            get { return "mcs_serviceplugin"; }
        }
        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.PostEntityImages["post"];
        }
        #endregion
    }
}