﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using System;

namespace VA.TMP.CRM
{
    public class AssignRecordCreatePostStageRunner : PluginRunner
    {
        public AssignRecordCreatePostStageRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }

        public override void Execute()
        {
            var ThisRecord = CvtHelper.ValidateReturnRecord(PrimaryEntity, PrimaryEntity.LogicalName, Logger, OrganizationService);
            CvtHelper.AssignOwner(ThisRecord, Logger, OrganizationService);
        }
       
        #region Additional Interface Methods
        public override string McsSettingsDebugField
        {
            get { return "cvt_assignment"; }
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
        #endregion
    }
}
