DROP TABLE ERX.INBOUND_NCPDP_MSG CASCADE CONSTRAINTS ;

CREATE TABLE ERX.INBOUND_NCPDP_MSG
  (
    INBOUND_NCPDP_MSG_ID NUMBER NOT NULL ,
    MESSAGE_ID           VARCHAR2 (35) ,
    REL_TO_MESSAGE_ID    VARCHAR2 (35) ,
    MESSAGE_TYPE         VARCHAR2 (35) ,
    MESSAGE_FROM         VARCHAR2 (35) ,
    MESSAGE XMLTYPE ,
    PHARMACY_ID            NUMBER DEFAULT 0 NOT NULL ,
    PATIENT_CHK_STATUS     VARCHAR2 (4) DEFAULT '0000' NOT NULL ,
    PATIENT_MATCH_DETAILS  VARCHAR2 (2000) ,
    PROVIDER_CHK_STATUS    VARCHAR2 (4) DEFAULT '0000' NOT NULL ,
    PROVIDER_MATCH_DETAILS VARCHAR2 (2000) ,
    DRUG_CHK_STATUS        VARCHAR2 (4) DEFAULT '0000' NOT NULL ,
    DRUG_MATCH_DETAILS     VARCHAR2 (2000) ,
    MESSAGE_STATUS         VARCHAR2 (4) DEFAULT '0000' NOT NULL ,
    RECEIVED_DATE          DATE ,
    UPDATED_DATE           DATE ,
    CREATED_DATE           DATE
  )
  LOGGING XMLTYPE COLUMN MESSAGE STORE AS BINARY XML
  (
    STORAGE ( PCTINCREASE 0 MINEXTENTS 1 MAXEXTENTS UNLIMITED FREELISTS 1 BUFFER_POOL DEFAULT ) RETENTION ENABLE STORAGE IN ROW NOCACHE
  ) ;
CREATE INDEX ERX.IB_NCPDP_MSG_IDX ON ERX.INBOUND_NCPDP_MSG
  (
    PHARMACY_ID ASC
  )
  LOGGING ;
CREATE UNIQUE INDEX ERX.IB_NCPDP_MSG_PK ON ERX.INBOUND_NCPDP_MSG
  (
    INBOUND_NCPDP_MSG_ID ASC
  )
  LOGGING ;
