package gov.va.med.pharmacy.jaxrs.eAnde.services.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.handler.WSHandlerConstants;

import gov.va.med.pharmacy.utility.StreamUtilities;
import gov.va.med.pharmacy.wsclients.eAnde.ClientPasswordCallback;
import gov.va.med.pharmacy.wsclients.eAnde.EeSummaryPort;
import gov.va.med.pharmacy.wsclients.eAnde.EeSummaryPortService;
import gov.va.med.pharmacy.wsclients.eAnde.GetEESummaryRequest;
import gov.va.med.pharmacy.wsclients.eAnde.getEESummaryResponse;


/**
 * JAX-WS Client for EESummary (Enrollment and Eligibility Service).
 *
 */
public final class EESummary_Client {

    private static final String E_AND_E_REQUEST_NAME = "eAnde.request.name";
	private static final String E_AND_E_USERNAME = "eAnde.username";
	private static final String E_AND_E_CLIENT_ENDPOINT = "eAnde.client.endpoint";
	private static final QName SERVICE_NAME = new QName("http://jaxws.webservices.esr.URL       /schemas", "eeSummaryPortService");

    public getEESummaryResponse returnResponse(String key) throws java.lang.Exception {
    	
        Properties properties = new Properties();
        
        String username = null;
        String eAndeEndpoint = null;
        String eAndeRequestName = null;
		
		InputStream inputStream = null;
		
		inputStream = this.getClass().getClassLoader().getResourceAsStream("gov.va.med.pharmacy.wsclients.properties");
		try{
			if(null!=inputStream){
				properties.load(inputStream);
			}
		}
		finally{
			if (null != inputStream) {
				StreamUtilities.safeClose(inputStream);
			}
		}
		eAndeEndpoint = properties.getProperty(E_AND_E_CLIENT_ENDPOINT).trim();
		
		username = properties.getProperty(E_AND_E_USERNAME).trim();
    	
		eAndeRequestName = properties.getProperty(E_AND_E_REQUEST_NAME).trim();
    	
		String url = "";

    	
        URL wsdlURL = EeSummaryPortService.WSDL_LOCATION;
     
        if (url.length() > 0 && url != null && !"".equals(url)) { 
            File wsdlFile = new File(url);
            try {
                if (wsdlFile.exists()) {
                    wsdlURL = wsdlFile.toURI().toURL();
                } else {
                    wsdlURL = new URL(url);
                }
            } catch (MalformedURLException e) {                
                
                throw new Exception(e); // let the exception go all the way up.
            }
        }
      
       EeSummaryPortService ss = new EeSummaryPortService(wsdlURL, SERVICE_NAME);
     
       EeSummaryPort port = ss.getEeSummaryPortSoap11(); 
      
       ((BindingProvider)port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,eAndeEndpoint);
                
       GetEESummaryRequest eeSummaryRequest = null;
  
       Client client = ClientProxy.getClient(port);
       Endpoint cxfEndpoint = client.getEndpoint();
 
        Map<String, Object> outProps = new HashMap<String, Object>();
        outProps.put(WSHandlerConstants.ACTION, WSHandlerConstants.USERNAME_TOKEN);
        outProps.put(WSHandlerConstants.USER, username);
        outProps.put(WSHandlerConstants.PASSWORD_TYPE, WSConstants.PW_TEXT);
        ClientPasswordCallback handler = new ClientPasswordCallback();
        outProps.put(WSHandlerConstants.PW_CALLBACK_REF, handler);

        WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(outProps);
       
        cxfEndpoint.getOutInterceptors().add(wssOut);
        
        eeSummaryRequest= new GetEESummaryRequest();
        
        eeSummaryRequest.setKey(key);

        eeSummaryRequest.setRequestName(eAndeRequestName);
        
        getEESummaryResponse eeSummaryResponse = port.getEESummary(eeSummaryRequest);
     
    	return eeSummaryResponse;
    }
    

}
