package gov.va.med.pharmacy.persistence.track.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import gov.va.med.pharmacy.persistence.report.VisnSelectModel;
import gov.va.med.pharmacy.persistence.track.VisnSelectDao;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class VisnSelectDaoImpl implements VisnSelectDao {

	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(VisnSelectDaoImpl.class);

	@Autowired
	private DataSource dataSource;


	public VisnSelectDaoImpl() {
	}

	public VisnSelectDaoImpl(DataSource dataSource) {
		this.dataSource = dataSource;
	}


	public class VisnListRowMapper implements RowMapper<VisnSelectModel>
	{
		public VisnSelectModel mapRow(ResultSet rs, int rowNum) throws SQLException{
			VisnSelectModel visnSelectModel = new VisnSelectModel();


			visnSelectModel.setId(rs.getString("visn"));
			visnSelectModel.setLabel(rs.getString("visn"));


			return visnSelectModel;
		}
	}



	@Override
	public List<VisnSelectModel> getVisns() {
		JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
		String sql = "";

		sql = "select distinct visn from pharmacy order by to_number(visn)"; 


		List<VisnSelectModel> visnList = new ArrayList<VisnSelectModel>();

		try {
			//LOG.info("Retrieving NCPDP message details.");
			//System.out.println("Retrieving unique VISN list.");
			visnList = jdbcTemplate.query(sql,new VisnListRowMapper());
		} catch (DataAccessException e) {
			//System.out.println("data error is:" + e.getMessage());
			LOG.info("Exception retrieving NCPDP message details." + e.getMessage());
		}

		return visnList;

	}

}
