package gov.va.med.pharmacy.persistence.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.pharmacy.persistence.report.VisnSelectModel;
import gov.va.med.pharmacy.persistence.service.TrackMessageService;
import gov.va.med.pharmacy.persistence.track.NcpdpMessageListModel;
import gov.va.med.pharmacy.persistence.track.NcpdpMessageModel;
import gov.va.med.pharmacy.persistence.track.NcpdpMessagesDao;
import gov.va.med.pharmacy.persistence.track.VisnSelectDao;


@Service("trackMessageService")
public class TrackMessageServiceImpl implements TrackMessageService {

	@Autowired
	private NcpdpMessagesDao ncpdpMessagesDao;
	
	@Autowired
	private VisnSelectDao visnSelectDao;
	
	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(TrackMessageServiceImpl.class);
	
	@Override
	public NcpdpMessageModel findByMessageId(String id, String inboundOutbound) {
		
			LOG.info("------ getting inbound/outbound message ---- ");

		return ncpdpMessagesDao.findById(id, inboundOutbound);
	}
	
	@Override
	public List<NcpdpMessageListModel> searchMessages(String messageType, String messageId, String relatesToId, String visn, String vaStationId,
			String fromDate, String toDate, String patientSsn, String patientLastName, String patientFirstName, String patientDob, String prescriberNpi,
			String prescriberLastName, String prescriberFirstName, String prescribedDrug, String messageStatus, String inboundNcpdpMsgId, String inboundOutbound) {
		
			LOG.info("------ getting inbound/outbound message ---- ");

		return ncpdpMessagesDao.searchMessages(messageType, messageId, relatesToId, visn, vaStationId, fromDate, toDate, patientSsn, patientLastName, patientFirstName, patientDob, prescriberNpi, prescriberLastName, prescriberFirstName, prescribedDrug, messageStatus, inboundNcpdpMsgId, inboundOutbound);
	}
	
	public List<VisnSelectModel> getVisns(){
		
		return visnSelectDao.getVisns();
	}

	
	
}
