DROP TABLE ERX.OUTBOUND_NCPDP_MSG CASCADE CONSTRAINTS ;

CREATE TABLE ERX.OUTBOUND_NCPDP_MSG
  (
    OUTBOUND_NCPDP_MSG_ID NUMBER NOT NULL ,
    MESSAGE_ID            VARCHAR2 (35) ,
    REL_TO_MESSAGE_ID     VARCHAR2 (35) ,
    MESSAGE_TYPE          VARCHAR2 (35) ,
    MESSAGE XMLTYPE ,
    PHARMACY_ID    NUMBER DEFAULT 0 NOT NULL ,
    MESSAGE_STATUS VARCHAR2 (4) DEFAULT '0000' NOT NULL ,
    MESSAGE_STATUS_DETAILS     VARCHAR2 (2000) ,
    RECEIVED_DATE  DATE ,
    UPDATED_DATE   DATE ,
    CREATED_DATE   DATE
  )
  PARTITION BY RANGE (RECEIVED_DATE) 
INTERVAL(NUMTOYMINTERVAL(1, 'MONTH')) 
(  
   PARTITION rcvd_date_p1 VALUES LESS THAN (TO_DATE('1-6-2017', 'DD-MM-YYYY')),
   PARTITION rcvd_date_p2 VALUES LESS THAN (TO_DATE('1-7-2017', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p3 VALUES LESS THAN (TO_DATE('1-8-2017', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p4 VALUES LESS THAN (TO_DATE('1-9-2017', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p5 VALUES LESS THAN (TO_DATE('1-10-2017', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p6 VALUES LESS THAN (TO_DATE('1-11-2017', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p7 VALUES LESS THAN (TO_DATE('1-12-2017', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p8 VALUES LESS THAN (TO_DATE('1-1-2018', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p9 VALUES LESS THAN (TO_DATE('1-2-2018', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p10 VALUES LESS THAN (TO_DATE('1-3-2018', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p11 VALUES LESS THAN (TO_DATE('1-4-2018', 'DD-MM-YYYY')), 
   PARTITION rcvd_date_p12 VALUES LESS THAN (TO_DATE('1-5-2018', 'DD-MM-YYYY')))
  LOGGING XMLTYPE COLUMN MESSAGE STORE AS BINARY XML
  (
    STORAGE ( PCTINCREASE 0 MINEXTENTS 1 MAXEXTENTS UNLIMITED FREELISTS 1 BUFFER_POOL DEFAULT ) RETENTION ENABLE STORAGE IN ROW NOCACHE
  )
  ALLOW NONSCHEMA ;
CREATE UNIQUE INDEX ERX.OB_NCPDP_MSG_ID_IDX ON ERX.OUTBOUND_NCPDP_MSG
  (
    OUTBOUND_NCPDP_MSG_ID ASC
  )
  LOGGING ;
  CREATE INDEX ERX.OB_NCPDP_MSG_PHARMACY_ID_IDX ON ERX.OUTBOUND_NCPDP_MSG
    (
      PHARMACY_ID ASC
    )
    LOGGING ;
