/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security.m;

import gov.va.med.crypto.VistaKernelHash;
import gov.va.med.crypto.VistaKernelHashCountLimitExceededException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestFactory;
import gov.va.med.vistalink.security.m.SecurityRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SecurityRequestFactory
implements VistaLinkRequestFactory {
    private static final String GOV_VA_MED_SECURITY_VERSION = "1.0";
    private static final String VISTALINK_VERSION = "1.6";
    private static final String GOV_VA_MED_SECURITY_REQUEST = "gov.va.med.foundations.security.request";
    private static final String NAMESPACE_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_SELECT_DIVISION = "secDivisionRequest.xsd";
    private static final String SCHEMA_LOGON = "secLogonRequest.xsd";
    private static final String SCHEMA_UPDATE_VC = "secUpdateVerifyRequest.xsd";
    private static final String SCHEMA_SIMPLE = "secSimpleRequest.xsd";
    private static final String SCHEMA_SETUP_INTRO = "secSetupIntroRequest.xsd";
    private static final String TEXT_REQUEST = "Request";
    private static final Logger logger = Logger.getLogger(SecurityRequestFactory.class);
    public static final String MSG_ACTION_SETUP_AND_INTRO_TEXT = "AV.SetupAndIntroText";
    public static final String MSG_ACTION_LOGON = "AV.Logon";
    public static final String MSG_ACTION_LOGOUT = "AV.Logout";
    public static final String MSG_ACTION_SELECT_DIVISION = "AV.SelectDivision";
    public static final String MSG_ACTION_UPDATE_VC = "AV.UpdateVC";
    public static final String MSG_ACTION_USER_DEMOGRAPHICS = "AV.GetUserDemographics";
    static final String CRLF = "\n";

    private SecurityRequestFactory() {
    }

    static SecurityRequest getAVSetupAndIntroTextRequest(boolean j2eeMode, Boolean isClientProduction, String primaryStation) throws ParserConfigurationException {
        Document requestDoc = SecurityRequestFactory.getBaseDoc(MSG_ACTION_SETUP_AND_INTRO_TEXT, SCHEMA_SETUP_INTRO);
        Element rootElement = requestDoc.getDocumentElement();
        NodeList nodeList = rootElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(TEXT_REQUEST)) continue;
            Element requestTypeElement = (Element)node;
            String ipString = "";
            try {
                InetAddress addr = InetAddress.getLocalHost();
                ipString = addr.getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.warn((Object)"Could not retrieve local IP address", (Throwable)e);
            }
            requestTypeElement.setAttribute("clientIp", ipString);
            if (!j2eeMode) continue;
            Element productionElement = requestDoc.createElement("productionInfo");
            productionElement.setAttribute("clientIsProduction", isClientProduction.toString().toLowerCase());
            productionElement.setAttribute("clientPrimaryStation", primaryStation);
            node.appendChild(productionElement);
            break;
        }
        return new SecurityRequest(requestDoc);
    }

    static SecurityRequest getAVLogoutRequest() throws ParserConfigurationException {
        Document requestDoc = SecurityRequestFactory.getBaseDoc(MSG_ACTION_LOGOUT, SCHEMA_SIMPLE);
        return new SecurityRequest(requestDoc);
    }

    static SecurityRequest getAVGetUserDemographicsRequest() throws ParserConfigurationException {
        Document requestDoc = SecurityRequestFactory.getBaseDoc(MSG_ACTION_USER_DEMOGRAPHICS, SCHEMA_SIMPLE);
        return new SecurityRequest(requestDoc);
    }

    static SecurityRequest getAVLogonRequest(String token) throws ParserConfigurationException {
        return SecurityRequestFactory.getAVLogonRequestInternal(token, false);
    }

    static SecurityRequest getAVLogonRequest(String ac, String vc, boolean requestCvc) throws ParserConfigurationException, VistaKernelHashCountLimitExceededException {
        return SecurityRequestFactory.getAVLogonRequestInternal(VistaKernelHash.encrypt((String)(ac + ";" + vc), (boolean)true), requestCvc);
    }

    private static SecurityRequest getAVLogonRequestInternal(String encodedLogonString, boolean requestCvc) throws ParserConfigurationException {
        Document requestDoc = SecurityRequestFactory.getBaseDoc(MSG_ACTION_LOGON, SCHEMA_LOGON);
        Element rootElement = requestDoc.getDocumentElement();
        NodeList nodeList = rootElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(TEXT_REQUEST)) continue;
            Element avCodesElement = requestDoc.createElement("avCodes");
            if (requestCvc) {
                avCodesElement.setAttribute("requestCvc", "true");
            }
            CDATASection cdata = requestDoc.createCDATASection(encodedLogonString);
            avCodesElement.appendChild(cdata);
            node.appendChild(avCodesElement);
            break;
        }
        return new SecurityRequest(requestDoc);
    }

    static SecurityRequest getAVLogonSelectDivisionRequest(String logonDivisionIen) throws ParserConfigurationException {
        Document requestDoc = SecurityRequestFactory.getBaseDoc(MSG_ACTION_SELECT_DIVISION, SCHEMA_SELECT_DIVISION);
        Element rootElement = requestDoc.getDocumentElement();
        NodeList nodeList = rootElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(TEXT_REQUEST)) continue;
            Element logonDivisionElement = requestDoc.createElement("Division");
            logonDivisionElement.setAttribute("ien", logonDivisionIen);
            node.appendChild(logonDivisionElement);
            break;
        }
        return new SecurityRequest(requestDoc);
    }

    static SecurityRequest getAVUpdateVCRequest(String oldVc, String newVc, String newVcCheck) throws ParserConfigurationException, VistaKernelHashCountLimitExceededException {
        Document requestDoc = SecurityRequestFactory.getBaseDoc(MSG_ACTION_UPDATE_VC, SCHEMA_UPDATE_VC);
        Element rootElement = requestDoc.getDocumentElement();
        NodeList nodeList = rootElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(TEXT_REQUEST)) continue;
            Element oldVcElement = requestDoc.createElement("oldVc");
            CDATASection cdata = requestDoc.createCDATASection(VistaKernelHash.encrypt((String)oldVc, (boolean)true));
            oldVcElement.appendChild(cdata);
            node.appendChild(oldVcElement);
            Element newVcElement = requestDoc.createElement("newVc");
            cdata = requestDoc.createCDATASection(VistaKernelHash.encrypt((String)newVc, (boolean)true));
            newVcElement.appendChild(cdata);
            node.appendChild(newVcElement);
            Element confirmedVcElement = requestDoc.createElement("confirmedVc");
            cdata = requestDoc.createCDATASection(VistaKernelHash.encrypt((String)newVcCheck, (boolean)true));
            confirmedVcElement.appendChild(cdata);
            node.appendChild(confirmedVcElement);
            break;
        }
        return new SecurityRequest(requestDoc);
    }

    private static Document getBaseDoc(String action, String schema) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document newDoc = builder.newDocument();
        Element root = newDoc.createElement("VistaLink");
        root.setAttribute("xmlns:xsi", NAMESPACE_XSI);
        root.setAttribute("xsi:noNamespaceSchemaLocation", schema);
        root.setAttribute("messageType", GOV_VA_MED_SECURITY_REQUEST);
        root.setAttribute("version", VISTALINK_VERSION);
        root.setAttribute("mode", "singleton");
        newDoc.appendChild(root);
        Element securityInfoElement = newDoc.createElement("SecurityInfo");
        securityInfoElement.setAttribute("version", GOV_VA_MED_SECURITY_VERSION);
        root.appendChild(securityInfoElement);
        Element requestTypeElement = newDoc.createElement(TEXT_REQUEST);
        requestTypeElement.setAttribute("type", action);
        root.appendChild(requestTypeElement);
        return newDoc;
    }
}

