/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.rpc;

import gov.va.med.xml.XmlUtilities;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class RpcXmlRequestParams {
    private Document requestDoc = null;
    private Node params = null;

    RpcXmlRequestParams(Document requestDoc) {
        this.requestDoc = requestDoc;
        this.params = XmlUtilities.getNode((String)"/VistaLink/Request/Params", (Node)requestDoc);
    }

    Node getParams() {
        return this.params;
    }

    void setParam(int position, String type, Object value) {
        Node node = XmlUtilities.getNode((String)("//Param[@position='" + position + "']"), (Node)this.params);
        if (node != null) {
            this.params.removeChild(node);
            node = null;
        }
        if (value instanceof Map) {
            Element param = this.requestDoc.createElement("Param");
            this.setType(param, "array");
            this.setPosition(param, Integer.toString(position));
            Element indices = this.requestDoc.createElement("Indices");
            Map map = (Map)value;
            for (Map.Entry me : map.entrySet()) {
                Element index = this.requestDoc.createElement("Index");
                Element indexName = this.requestDoc.createElement("Name");
                Element indexValue = this.requestDoc.createElement("Value");
                indexName.appendChild(this.requestDoc.createTextNode(me.getKey().toString()));
                indexValue.appendChild(this.requestDoc.createTextNode(me.getValue().toString()));
                index.appendChild(indexName);
                index.appendChild(indexValue);
                indices.appendChild(index);
            }
            param.appendChild(indices);
            this.params.appendChild(param);
        } else if (value instanceof List) {
            List list = (List)value;
            this.setIndices(position, list.iterator());
        } else if (value instanceof Set) {
            Set set = (Set)value;
            this.setIndices(position, set.iterator());
        } else {
            Element param = this.requestDoc.createElement("Param");
            this.setType(param, type);
            this.setPosition(param, Integer.toString(position));
            param.appendChild(this.requestDoc.createTextNode(value.toString()));
            this.params.appendChild(param);
        }
    }

    private void setIndices(int position, Iterator it) {
        Element param = this.requestDoc.createElement("Param");
        this.setType(param, "array");
        this.setPosition(param, Integer.toString(position));
        int item = 0;
        Element indices = this.requestDoc.createElement("Indices");
        while (it.hasNext()) {
            Element index = this.requestDoc.createElement("Index");
            Element indexName = this.requestDoc.createElement("Name");
            Element indexValue = this.requestDoc.createElement("Value");
            indexName.appendChild(this.requestDoc.createTextNode(String.valueOf(++item)));
            indexValue.appendChild(this.requestDoc.createTextNode(it.next().toString()));
            index.appendChild(indexName);
            index.appendChild(indexValue);
            indices.appendChild(index);
        }
        param.appendChild(indices);
        this.params.appendChild(param);
    }

    private void setType(Element param, String value) {
        Attr attr = this.requestDoc.createAttribute("type");
        attr.setValue(value);
        param.setAttributeNode(attr);
    }

    private void setPosition(Element param, String value) {
        Attr attr = this.requestDoc.createAttribute("position");
        attr.setValue(value);
        param.setAttributeNode(attr);
    }
}

