/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.rpc;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestParam;
import gov.va.med.vistalink.rpc.RpcRequestParams;
import gov.va.med.vistalink.rpc.RpcXmlRequest;
import gov.va.med.vistalink.rpc.RpcXmlRequestParams;
import gov.va.med.xml.XmlUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class RpcXmlRequestFactory {
    private static final Logger logger = Logger.getLogger(RpcXmlRequestFactory.class);

    RpcXmlRequestFactory() {
    }

    static RpcXmlRequest getRpcXmlRequest(RpcRequest rpcRequest) throws FoundationsException {
        try {
            RpcXmlRequest rpcXmlRequest = new RpcXmlRequest(XmlUtilities.getDocumentForXmlString((String)RpcXmlRequestFactory.getBaseXml()));
            if (rpcRequest.getRpcName() != null) {
                rpcXmlRequest.setRpcName(rpcRequest.getRpcName());
            }
            if (rpcRequest.getRpcContext() != null) {
                rpcXmlRequest.setRpcContext(rpcRequest.getRpcContext());
            }
            if (rpcRequest.getRpcClientTimeOut() > 0) {
                rpcXmlRequest.setRpcClientTimeOut(rpcRequest.getRpcClientTimeOut());
            }
            rpcXmlRequest.setRpcVersion(rpcRequest.getRpcVersion());
            if (rpcRequest.getVlConnSpec() != null) {
                rpcXmlRequest.setReAuthenticateInfo(rpcRequest.getVlConnSpec());
            }
            RpcXmlRequestFactory.buildParams(rpcRequest.getParams(), rpcXmlRequest.getParams());
            return rpcXmlRequest;
        }
        catch (FoundationsException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)new StringBuffer().append("Can not create RpcXmlRequest.").append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)e)).toString());
            }
            throw e;
        }
    }

    private static void buildParams(RpcRequestParams params, RpcXmlRequestParams xmlParams) {
        int paramCount = params.getParams().size();
        if (paramCount == 0) {
            return;
        }
        RpcRequestParam param = null;
        int posNumber = 0;
        for (int i = 0; i < paramCount; ++i) {
            posNumber = i + 1;
            String posString = String.valueOf(posNumber);
            if (!params.getParams().containsKey(String.valueOf(posString))) continue;
            param = (RpcRequestParam)params.getParams().get(posString);
            xmlParams.setParam(posNumber, param.getType(), param.getValue());
        }
    }

    private static String getBaseXml() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\" ?><VistaLink messageType='gov.va.med.foundations.rpc.request' mode='singleton' version='1.6' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:noNamespaceSchemaLocation='rpcRequest.xsd'>  <RpcHandler version='1.6'/>  <Request rpcName='' rpcClientTimeOut='600' rpcVersion='0' >    <Security type='' state='virgin' division=''></Security>    <RpcContext></RpcContext>    <Params></Params>  </Request></VistaLink>";
    }
}

