/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.rpc;

import gov.va.med.crypto.VistaKernelHash;
import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpecImpl;
import gov.va.med.vistalink.adapter.spi.EMReAuthState;
import gov.va.med.vistalink.rpc.RpcXmlRequestParams;
import gov.va.med.xml.XmlUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class RpcXmlRequest {
    private static final Logger logger = Logger.getLogger(RpcXmlRequest.class);
    static final String GOV_VA_MED_RPC_REQUEST = "gov.va.med.foundations.rpc.request";
    private RpcXmlRequestParams params;
    private Attr rpcName;
    private Attr rpcClientTimeOut;
    private Attr rpcVersion;
    private String rpcContext;
    private Node rpcSecurityNode;
    private Document requestDoc = null;

    RpcXmlRequest(Document requestDoc) throws FoundationsException {
        this.requestDoc = requestDoc;
        Node reqNode = XmlUtilities.getNode((String)"/VistaLink/Request", (Node)requestDoc);
        this.rpcName = XmlUtilities.getAttr((Node)reqNode, (String)"rpcName");
        this.rpcClientTimeOut = XmlUtilities.getAttr((Node)reqNode, (String)"rpcClientTimeOut");
        this.rpcVersion = XmlUtilities.getAttr((Node)reqNode, (String)"rpcVersion");
        this.params = new RpcXmlRequestParams(requestDoc);
        this.rpcSecurityNode = XmlUtilities.getNode((String)"/VistaLink/Request/Security", (Node)requestDoc);
    }

    RpcXmlRequestParams getParams() {
        return this.params;
    }

    String getRpcName() {
        return this.rpcName.getValue();
    }

    void setRpcName(String value) {
        this.rpcName.setValue(value);
    }

    String getRpcContext() {
        return this.rpcContext;
    }

    void setRpcContext(String value) throws FoundationsException {
        try {
            this.rpcContext = value;
            Node node = XmlUtilities.getNode((String)"/VistaLink/Request/RpcContext", (Node)this.requestDoc);
            String encryptedRpcContext = VistaKernelHash.encrypt((String)this.rpcContext, (boolean)true);
            CDATASection cdata = this.requestDoc.createCDATASection(encryptedRpcContext);
            Node currentRpcContextNode = node.getFirstChild();
            if (currentRpcContextNode != null) {
                node.removeChild(currentRpcContextNode);
            }
            node.appendChild(cdata);
        }
        catch (FoundationsException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)new StringBuffer().append("Can not set RpcContext.").append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)e)).toString());
            }
            throw e;
        }
    }

    int getRpcClientTimeOut() {
        return Integer.parseInt(this.rpcClientTimeOut.getValue());
    }

    void setRpcClientTimeOut(int value) {
        this.rpcClientTimeOut.setValue(String.valueOf(value));
    }

    Attr getRpcVersion() {
        return this.rpcVersion;
    }

    void setRpcVersion(double value) {
        this.rpcVersion.setValue(String.valueOf(value));
    }

    void setReAuthenticateInfo(VistaLinkConnectionSpecImpl connSpec) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting re-authentication information in request document");
        }
        if (connSpec != null) {
            connSpec.clearSecurityNode(this.rpcSecurityNode);
            connSpec.setSecurityTypeAttr(this.rpcSecurityNode);
            connSpec.setSecurityStateAttr(this.rpcSecurityNode);
            if (!connSpec.getSecurityState().equals(EMReAuthState.AUTHENTICATED)) {
                connSpec.setAuthenticationNodes(this.requestDoc, this.rpcSecurityNode);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"the conn spec is null!!!");
        }
    }

    String getRequestString() throws FoundationsException {
        if (this.requestDoc == null) {
            String errStr = "Can not return request String as requestDoc == null. Make sure to initialize Request appropriately.";
            FoundationsException e = new FoundationsException(errStr);
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String errMsg = ExceptionUtils.getFullStackTrace((Throwable)e);
                logger.error((Object)errMsg);
            }
            throw e;
        }
        String xmlString = "";
        try {
            xmlString = XmlUtilities.convertXmlToStr((Document)this.requestDoc);
        }
        catch (FoundationsException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String errMsg = new StringBuffer().append("Converting requestDoc to XML String failed.").append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)e)).toString();
                logger.error((Object)errMsg);
            }
            throw e;
        }
        return xmlString;
    }
}

